package com.antai.sport.http.server.server.api.business.user.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.sportusergamecurrency.dto.SportUserCurrencyPageDTO;
import com.antai.sport.http.server.server.api.business.sportusergamecurrency.dto.SportUserCurrencyPageVO;
import com.antai.sport.http.server.server.api.business.sportusergamecurrency.dto.SportUserCurrencyVO;
import com.antai.sport.http.server.server.api.business.sportusergamecurrency.service.SportUserGameCurrencyService;
import com.antai.sport.http.server.server.api.business.traininglog.dto.SportUserTrainingLogVO;
import com.antai.sport.http.server.server.api.business.traininglog.dto.TrainingDetailVO;
import com.antai.sport.http.server.server.api.business.traininglog.service.SportUserTrainingLogService;
import com.antai.sport.http.server.server.api.business.user.dto.*;
import com.antai.sport.http.server.server.api.business.user.service.SportUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@Api(tags = {"用户相关接口"})
@RestController
@RequestMapping("user")
public class SportUserController {
    @Resource
    private SportUserService sportUserService;
    @Resource
    private SportUserTrainingLogService sportUserTrainingLogService;
    @Resource
    private SportUserGameCurrencyService sportUserGameCurrencyService;

    @ApiOperation("查询用户主页数据")
    @GetMapping("{userId}")
    public ResponseEntity<Result<RespUserHomeInfo>> getUserHomeInfo(@PathVariable("userId") Long userId) {
        return success(sportUserService.getUserHomeInfo(userId));
    }

    @ApiOperation("查询用户运动记录")
    @PostMapping("/training/log")
    public ResponseEntity<Result<List<SportUserTrainingLogVO>>> getSportUserTrainingLog(@RequestBody ReqSportUserTrainingLog param) {
        return success(sportUserTrainingLogService.getSportUserTrainingLog(param));
    }

    @ApiOperation("查询我的排名 type: 1能力榜 2活跃度榜")
    @GetMapping("/{userId}/rank")
    public ResponseEntity<Result<SportUserMonthRankResponseDTO>> getMyRank(@PathVariable("userId") Long userId,
                                                                           @RequestParam Integer type,
                                                                           @RequestParam Integer year,
                                                                           @RequestParam Integer month) {
        return success(sportUserTrainingLogService.getMyRank(userId, type, year, month));
    }


    @ApiOperation("查询玩家排名列表")
    @PostMapping("/rank")
    public ResponseEntity<Result<List<SportUserMonthRankResponseDTO>>> geRank(@RequestBody SportUserMonthRankRequestDTO param) {
        return success(sportUserTrainingLogService.geRank(param));
    }


    @ApiOperation("查询玩家运动日历")
    @PostMapping("/{userId}/schedule")
    public ResponseEntity<Result<List<ScheduleResponseDTO>>> getSchedule(@PathVariable("userId") Long userId,
                                                                         @RequestParam Integer year,
                                                                         @RequestParam Integer month) {
        return success(sportUserTrainingLogService.getSchedule(userId, year, month));
    }

    @ApiOperation("查询用户运动记录详情")
    @GetMapping("/training/log/{id}")
    public ResponseEntity<Result<TrainingDetailVO>> getSportUserTrainingLogRank(@PathVariable("id") Long Id) {
        return success(sportUserTrainingLogService.getTrainingDetail(Id));
    }

    @ApiOperation("用户登录日志处理")
    @GetMapping("/sign/in/{sportUserId}")
    public ResponseEntity<Result> signIn(@PathVariable("sportUserId") Long sportUserId) {
        sportUserService.signIn(sportUserId);
        return success();
    }


    @ApiOperation("获取用户积分接口")
    @GetMapping("/currency/{sportUserId}")
    public ResponseEntity<Result<SportUserCurrencyVO>> getUserCurrency(@PathVariable("sportUserId") Long sportUserId) {
        return success(sportUserGameCurrencyService.getUserCurrency(sportUserId));
    }

    @ApiOperation("获取用户积分列表")
    @PostMapping("/currency/page/{sportUserId}")
    public ResponseEntity<Result<List<SportUserCurrencyPageVO>>> getUserCurrencyPage(@PathVariable("sportUserId") Long sportUserId, @RequestBody SportUserCurrencyPageDTO param) {
        return success(sportUserGameCurrencyService.getUserCurrencyPage(sportUserId, param));
    }

    @ApiOperation("获取用户是否有未读消息接口")
    @GetMapping("/new/message/{sportUserId}")
    public ResponseEntity<Result<NewMessageVO>> getUserNewMessage(@PathVariable("sportUserId") Long sportUserId) {
        return success(sportUserService.getUserNewMessage(sportUserId));
    }

    @ApiOperation("根据卡路里、排名计算积分")
    @PostMapping("/calc/currency")
    public ResponseEntity<Result<Integer>> calcCurrency(@RequestBody CalcCurrencyDTO param) {
        return success(sportUserTrainingLogService.calcCurrency(param.getGameMode(), param.getCalorie(),
                param.getRank()));
    }
}
