package com.antai.sport.http.server.server.api.business.traininglog.service;

import com.antai.sport.http.server.constants.*;
import com.antai.sport.http.server.repository.club.entity.Club;
import com.antai.sport.http.server.repository.club.entity.ClubMember;
import com.antai.sport.http.server.repository.club.mapper.ClubMapper;
import com.antai.sport.http.server.repository.club.mapper.ClubMemberMapper;
import com.antai.sport.http.server.repository.roommode.entity.RoomMode;
import com.antai.sport.http.server.repository.roommode.mapper.RoomModeMapper;
import com.antai.sport.http.server.repository.shop.entity.SportUserGameCurrencyBaseRule;
import com.antai.sport.http.server.repository.shop.entity.SportUserGameCurrencyLog;
import com.antai.sport.http.server.repository.shop.entity.SportUserGameCurrencyMatchRule;
import com.antai.sport.http.server.repository.shop.mapper.SportUserGameCurrencyBaseRuleMapper;
import com.antai.sport.http.server.repository.shop.mapper.SportUserGameCurrencyLogMapper;
import com.antai.sport.http.server.repository.shop.mapper.SportUserGameCurrencyMatchRuleMapper;
import com.antai.sport.http.server.repository.simplematch.entity.SimpleMatch;
import com.antai.sport.http.server.repository.simplematch.mapper.SimpleMatchMapper;
import com.antai.sport.http.server.repository.sport.entity.*;
import com.antai.sport.http.server.repository.sport.mapper.*;
import com.antai.sport.http.server.repository.teamtraining.entity.TeamTraining;
import com.antai.sport.http.server.repository.teamtraining.mapper.TeamTrainingMapper;
import com.antai.sport.http.server.server.api.business.achievement.service.AchievementService;
import com.antai.sport.http.server.server.api.business.base.mapper.BaseBusinessMapper;
import com.antai.sport.http.server.server.api.business.simplematch.dto.SimpleMatchUserScheduleVO;
import com.antai.sport.http.server.server.api.business.simplematch.mapper.SimpleMatchBusinessMapper;
import com.antai.sport.http.server.server.api.business.sportusergamecurrency.service.SportUserGameCurrencyService;
import com.antai.sport.http.server.server.api.business.teamtraining.dto.TeamTrainingUserScheduleVO;
import com.antai.sport.http.server.server.api.business.teamtraining.mapper.TeamTrainingBusinessMapper;
import com.antai.sport.http.server.server.api.business.traininglog.converter.SportUserTrainingLogConverter;
import com.antai.sport.http.server.server.api.business.traininglog.dto.SportUserTrainingLogSummaryVO;
import com.antai.sport.http.server.server.api.business.traininglog.dto.SportUserTrainingLogVO;
import com.antai.sport.http.server.server.api.business.traininglog.dto.TrainingDetailVO;
import com.antai.sport.http.server.server.api.business.traininglog.mapper.SportUserTrainingLogBusinessMapper;
import com.antai.sport.http.server.server.api.business.user.converter.SportUserConverter;
import com.antai.sport.http.server.server.api.business.user.dto.*;
import com.antai.sport.http.server.server.api.business.user.mapper.SportUserMonthRankBusinessMapper;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import com.antai.sport.http.server.server.api.utils.ScoreUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class SportUserTrainingLogService {
    @Resource
    private SportUserTrainingLogMapper sportUserTrainingLogMapper;
    @Resource
    private SportUserSummaryMapper sportUserSummaryMapper;
    @Resource
    private SportUserMonthRankMapper sportUserMonthRankMapper;
    @Resource
    private SportUserMapper sportUserMapper;
    @Resource
    private SimpleMatchMapper simpleMatchMapper;
    @Resource
    private RoomModeMapper roomModeMapper;
    @Resource
    private TeamTrainingMapper teamTrainingMapper;
    @Resource
    private SportUserRankMapper sportUserRankMapper;
    @Resource
    private ClubMemberMapper clubMemberMapper;
    @Resource
    private ClubMapper clubMapper;
    @Resource
    private SportUserGameCurrencyLogMapper sportUserGameCurrencyLogMapper;

    @Resource
    private SportUserTrainingLogBusinessMapper sportUserTrainingLogBusinessMapper;
    @Resource
    private SportUserMonthRankBusinessMapper sportUserMonthRankBusinessMapper;
    @Resource
    private SimpleMatchBusinessMapper simpleMatchBusinessMapper;
    @Resource
    private TeamTrainingBusinessMapper teamTrainingBusinessMapper;
    @Resource
    private SportUserGameCurrencyBaseRuleMapper sportUserGameCurrencyBaseRuleMapper;
    @Resource
    private SportUserGameCurrencyMatchRuleMapper sportUserGameCurrencyMatchRuleMapper;
    @Resource
    private BaseBusinessMapper baseBusinessMapper;
    @Resource
    private SportUserFtpChangeLogMapper sportUserFtpChangeLogMapper;

    @Resource
    private SportUserTrainingLogConverter sportUserTrainingLogConverter;
    @Resource
    private SportUserConverter sportUserConverter;

    @Resource
    private SportUserGameCurrencyService sportUserGameCurrencyService;
    @Resource
    private AchievementService achievementService;

    public void createBicycleTrainingLog(Long playerId, Integer gameMode, Long sourceId, String sourceName,
                                         String map, String path, Integer praiseNum, CyclingDataDTO sportData) {
        SportUserTrainingLog log = sportUserTrainingLogConverter.toSportUserTrainingLog(sportData);
        log.setSportType(SportType.BICYCLE);
        log.setGameMode(gameMode);
        log.setPlayerId(playerId);
        log.setSourceId(sourceId);
        log.setSourceName(sourceName);
        log.setMap(map);
        log.setPath(path);
        log.setPraiseNum(praiseNum);
        log.setCreateTime(LocalDateTime.now());
        log.setCreateDate(LocalDate.now());
        //处理是否俱乐部日志
        QueryWrapper<ClubMember> clubMemberQuery = new QueryWrapper<>();
        clubMemberQuery.lambda().eq(ClubMember::getSportUserId, playerId).eq(ClubMember::getDeleted,
                DeleteStatus.UNDELETED);
        ClubMember clubMember = clubMemberMapper.selectOne(clubMemberQuery);
        if (clubMember != null) {
            log.setClubId(clubMember.getClubId());
        }
        sportUserTrainingLogMapper.insert(log);
        //处理玩家记录汇总
        SportUserSummary summary = this.handleSportUserSummary(playerId, log, gameMode, sportData);
        //处理俱乐部数据汇总
        this.handleClubSummary(clubMember, log);
        //处理月度排行
        this.modifyMonthRank(playerId, log);
        //处理总排行
        this.modifyTotalRank(playerId, log);
        //处理玩家积分
        this.handleSportUserCurrency(playerId, log.getId(), log.getCalorie(), gameMode, log.getMatchRank(),
                log.getSourceName(), log.getPath());
        //处理玩家成就
        achievementService.handleSportAchievement(gameMode, summary);
        //处理ftp变化事件
        handleFtpChange(playerId,sportData.getTwentyMinutesFtp());
    }

    void handleFtpChange(Long sportUserId, BigDecimal twentyMinutesFtp) {
        if (twentyMinutesFtp == null || twentyMinutesFtp.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        SportUser sportUser = sportUserMapper.selectById(sportUserId);
        BigDecimal oldFtp = sportUser.getFtp() == null ? BigDecimal.ZERO : BigDecimal.valueOf(sportUser.getFtp());
        BigDecimal newFtp = twentyMinutesFtp.multiply(BigDecimal.valueOf(0.93)).setScale(0, RoundingMode.HALF_UP);
        if(newFtp.compareTo(oldFtp) == 1) {
            sportUser.setFtp(newFtp.intValue());
            sportUserMapper.updateById(sportUser);
            SportUserFtpChangeLog ftpChangeLog = new SportUserFtpChangeLog();
            ftpChangeLog.setSportUserId(sportUserId);
            ftpChangeLog.setOldFtp(oldFtp.intValue());
            ftpChangeLog.setNewFtp(newFtp.intValue());
            ftpChangeLog.setCreateTime(LocalDateTime.now());
            ftpChangeLog.setHaveRead(false);
            sportUserFtpChangeLogMapper.insert(ftpChangeLog);
        }
    }

    /**
     * 计算积分
     * @param gameMode
     * @param calorie
     * @param rank
     * @return
     */
    public Integer calcCurrency(Integer gameMode, Integer calorie , Integer rank){
        if (calorie == null || calorie == 0) {
            return 0;
        }
        List<SportUserGameCurrencyBaseRule> baseRule = sportUserGameCurrencyBaseRuleMapper.selectList(null);
        if (baseRule.size() == 0 || baseRule.get(0).getCoefficient() == null) {
            return 0;
        }
        Integer coefficient = baseRule.get(0).getCoefficient();
        Integer currency = calorie / coefficient;
        if (currency == 0) {
            return 0;
        }
        if(rank !=null){
            SportUserGameCurrencyMatchRule matchRule =
                    sportUserGameCurrencyMatchRuleMapper.selectOne(new QueryWrapper<SportUserGameCurrencyMatchRule>().lambda().eq(SportUserGameCurrencyMatchRule::getGameMode, gameMode).le(SportUserGameCurrencyMatchRule::getRankStart, rank).ge(SportUserGameCurrencyMatchRule::getRankEnd, rank));
            if (matchRule != null && matchRule.getRate() != null) {
                currency = matchRule.getRate().multiply(BigDecimal.valueOf(currency)).intValue();
            }
        }
        return  currency;
    }

    /**
     * 处理用户积分
     *
     * @param playerId
     * @param gameMode
     * @param rank
     */
    public void handleSportUserCurrency(Long playerId, Long logId, Integer calorie, Integer gameMode, Integer rank,
                                        String sourceName, String pathKey) {
        if (calorie == null || calorie == 0) {
            return;
        }
        List<SportUserGameCurrencyBaseRule> baseRule = sportUserGameCurrencyBaseRuleMapper.selectList(null);
        if (baseRule.size() == 0 || baseRule.get(0).getCoefficient() == null) {
            return;
        }
        Integer coefficient = baseRule.get(0).getCoefficient();
        Integer currency = calorie / coefficient;
        if (currency == 0) {
            return;
        }
        SportUserGameCurrencyMatchRule matchRule =
                sportUserGameCurrencyMatchRuleMapper.selectOne(new QueryWrapper<SportUserGameCurrencyMatchRule>().lambda().eq(SportUserGameCurrencyMatchRule::getGameMode, gameMode).le(SportUserGameCurrencyMatchRule::getRankStart, rank).ge(SportUserGameCurrencyMatchRule::getRankEnd, rank));
        if (matchRule != null && matchRule.getRate() != null) {
            currency = matchRule.getRate().multiply(BigDecimal.valueOf(currency)).intValue();
        }
        String gameModeName = baseBusinessMapper.getGameMode(gameMode);
        String description;
        if(gameMode == GameMode.TOUR || gameMode == GameMode.COURSE_TRAINING) {
            String pathName = baseBusinessMapper.getMapPath(pathKey);
            description = gameModeName + "：" + pathName;
        } else {
            description = gameModeName + "：" + sourceName;
        }
        sportUserGameCurrencyService.addCurrency(playerId, currency, GameCurrencySourceType.SPORT, logId, description);
    }

    /**
     * 处理玩家记录汇总
     *
     * @param playerId
     * @param log
     */
    private SportUserSummary handleSportUserSummary(Long playerId, SportUserTrainingLog log, Integer gameMode,
                                                    CyclingDataDTO sportData) {
        QueryWrapper<SportUserSummary> summaryQuery = new QueryWrapper<>();
        summaryQuery.eq("deleted", DeleteStatus.UNDELETED);
        summaryQuery.eq("user_id", playerId);
        summaryQuery.eq("type", SportType.BICYCLE);
        SportUserSummary summary = sportUserSummaryMapper.selectOne(summaryQuery);
        if (summary == null) {
            summary = new SportUserSummary();
            summary.setUserId(playerId);
            summary.setType(SportType.BICYCLE);
            summary.setTotalDistance(BigDecimal.ZERO);
            summary.setTotalClimbDistance(BigDecimal.ZERO);
            summary.setTotalDuration(0);
            summary.setTotalPraiseNum(0);
            summary.setTotalCalorie(0);
            summary.setTotalTeamTrainingFinishNum(0);
            summary.setTotalSimpleMatchFinishNum(0);
            summary.setTotalGameModeFinishNum(0);
            summary.setTotalPraiseNum(0);
            summary.setViews(0);
        }
        summary.setTotalDuration(summary.getTotalDuration() + log.getDuration());
        summary.setTotalDistance(summary.getTotalDistance().add(log.getDistance()));
        summary.setTotalClimbDistance(summary.getTotalClimbDistance().add(log.getClimbDistance()));
        summary.setTotalCalorie(summary.getTotalCalorie() + log.getCalorie());
        if (gameMode.equals(GameMode.SIMPLE_MATCH) && sportData.getStatus().equals(ActivityStatus.FINISHED)) {
            summary.setTotalSimpleMatchFinishNum(summary.getTotalSimpleMatchFinishNum() + 1);
        }
        if (gameMode.equals(GameMode.GROUP_TRAINING) && sportData.getStatus().equals(ActivityStatus.FINISHED)) {
            summary.setTotalTeamTrainingFinishNum(summary.getTotalTeamTrainingFinishNum() + 1);
        }
        if (gameMode.equals(GameMode.ROOM_MODE) && sportData.getStatus().equals(ActivityStatus.FINISHED)) {
            summary.setTotalGameModeFinishNum(summary.getTotalGameModeFinishNum() + 1);
        }
        if (summary.getId() == null) {
            sportUserSummaryMapper.insert(summary);
        } else {
            sportUserSummaryMapper.updateById(summary);
        }
        return summary;
    }

    /**
     * 处理俱乐部汇总数据
     *
     * @param clubMember
     * @param log
     */
    private void handleClubSummary(ClubMember clubMember, SportUserTrainingLog log) {
        if (clubMember == null) {
            return;
        }
        Club club = clubMapper.selectById(clubMember.getClubId());
        club.setTotalDuration(club.getTotalDuration() + log.getDuration());
        club.setTotalDistance(club.getTotalDistance().add(log.getDistance()));
        club.setTotalClimbDistance(club.getTotalClimbDistance().add(log.getClimbDistance()));
        club.setTotalCalorie(club.getTotalCalorie() + log.getCalorie());
        clubMapper.updateById(club);
    }

    /**
     * 用户月排行榜修改
     *
     * @param playerId
     * @param log
     */
    private void modifyMonthRank(Long playerId, SportUserTrainingLog log) {
        Integer year = LocalDate.now().getYear();
        Integer month = LocalDate.now().getMonthValue();
        QueryWrapper<SportUserMonthRank> monthRankQuery = new QueryWrapper<>();
        monthRankQuery.eq("year", year);
        monthRankQuery.eq("month", month);
        monthRankQuery.eq("player_id", playerId);
        SportUserMonthRank rank = sportUserMonthRankMapper.selectOne(monthRankQuery);
        if (rank == null) {
            rank = sportUserTrainingLogConverter.toSportUserMonthRank(log, year, month);
            sportUserMonthRankMapper.insert(rank);
            return;
        }
        rank.setTotalCalorie(rank.getTotalCalorie() + log.getCalorie());
        rank.setUpdateTime(LocalDateTime.now());
        if (log.getOneMinutesFtp().compareTo(rank.getOneMinutesFtp()) == 1) {
            rank.setOneMinutesFtp(log.getOneMinutesFtp());
        }
        if (log.getFiveMinutesFtp().compareTo(rank.getFiveMinutesFtp()) == 1) {
            rank.setFiveMinutesFtp(log.getFiveMinutesFtp());
        }
        if (log.getTwentyMinutesFtp().compareTo(rank.getTwentyMinutesFtp()) == 1) {
            rank.setTwentyMinutesFtp(log.getTwentyMinutesFtp());
        }
        if (log.getOneMinutesWkg().compareTo(rank.getOneMinutesWkg()) == 1) {
            rank.setOneMinutesWkg(log.getOneMinutesWkg());
        }
        if (log.getFiveMinutesWkg().compareTo(rank.getFiveMinutesWkg()) == 1) {
            rank.setFiveMinutesWkg(log.getFiveMinutesWkg());
        }
        if (log.getTwentyMinutesWkg().compareTo(rank.getTwentyMinutesWkg()) == 1) {
            rank.setTwentyMinutesWkg(log.getTwentyMinutesWkg());
        }
        rank.setScore(ScoreUtils.calculate(rank.getOneMinutesFtp(), rank.getFiveMinutesFtp(),
                rank.getTwentyMinutesFtp(), rank.getOneMinutesWkg(), rank.getFiveMinutesWkg(),
                rank.getTwentyMinutesWkg()));
        sportUserMonthRankMapper.updateById(rank);
    }

    /**
     * 用户总排行榜修改
     *
     * @param log
     * @param playerId
     */
    private void modifyTotalRank(Long playerId, SportUserTrainingLog log) {
        QueryWrapper<SportUserRank> rankQuery = new QueryWrapper<>();
        rankQuery.eq("player_id", playerId);
        SportUserRank rank = sportUserRankMapper.selectOne(rankQuery);
        if (rank == null) {
            rank = sportUserTrainingLogConverter.toSportUserRank(log);
            sportUserRankMapper.insert(rank);
            return;
        }
        rank.setTotalCalorie(rank.getTotalCalorie() + log.getCalorie());
        rank.setUpdateTime(LocalDateTime.now());
        if (log.getOneMinutesFtp().compareTo(rank.getOneMinutesFtp()) == 1) {
            rank.setOneMinutesFtp(log.getOneMinutesFtp());
        }
        if (log.getFiveMinutesFtp().compareTo(rank.getFiveMinutesFtp()) == 1) {
            rank.setFiveMinutesFtp(log.getFiveMinutesFtp());
        }
        if (log.getTwentyMinutesFtp().compareTo(rank.getTwentyMinutesFtp()) == 1) {
            rank.setTwentyMinutesFtp(log.getTwentyMinutesFtp());
        }
        if (log.getOneMinutesWkg().compareTo(rank.getOneMinutesWkg()) == 1) {
            rank.setOneMinutesWkg(log.getOneMinutesWkg());
        }
        if (log.getFiveMinutesWkg().compareTo(rank.getFiveMinutesWkg()) == 1) {
            rank.setFiveMinutesWkg(log.getFiveMinutesWkg());
        }
        if (log.getTwentyMinutesWkg().compareTo(rank.getTwentyMinutesWkg()) == 1) {
            rank.setTwentyMinutesWkg(log.getTwentyMinutesWkg());
        }
        rank.setScore(ScoreUtils.calculate(rank.getOneMinutesFtp(), rank.getFiveMinutesFtp(),
                rank.getTwentyMinutesFtp(), rank.getOneMinutesWkg(), rank.getFiveMinutesWkg(),
                rank.getTwentyMinutesWkg()));
        sportUserRankMapper.updateById(rank);
    }

    /**
     * 获取用户某个运动下的最长记录
     *
     * @param sportType
     * @param userId
     * @return
     */
    public SportUserTrainingLog getLongestTrainingLog(Integer sportType, Long userId) {
        return sportUserTrainingLogBusinessMapper.getLongestTrainingLog(sportType, userId);
    }

    /**
     * 获取时间范围内运动数据汇总
     *
     * @param sportType     运动类型
     * @param userId        用户Id
     * @param daysCondition 统计天数
     * @return
     */
    public SportUserTrainingLogSummaryVO getTrainingLogSummary(Integer sportType, Long userId, Integer daysCondition) {
        LocalDate now = LocalDate.now();
        LocalDate beginDate = now.minusDays(daysCondition - 1);
        SportUserTrainingLogSummaryVO summaryVO = sportUserTrainingLogBusinessMapper.getTrainingLogSummary(sportType,
                userId, beginDate, now);
        if (summaryVO == null) {
            summaryVO = new SportUserTrainingLogSummaryVO();
            summaryVO.setLongestDistance(BigDecimal.ZERO);
            summaryVO.setTotalDistance(BigDecimal.ZERO);
            summaryVO.setTotalClimbDistance(BigDecimal.ZERO);
            summaryVO.setCalorie(0);
            summaryVO.setTotalDuration(0);
        }
        return summaryVO;
    }

    /**
     * 查询用户训练记录
     *
     * @param param
     * @return
     */
    public List<SportUserTrainingLogVO> getSportUserTrainingLog(ReqSportUserTrainingLog param) {
        return sportUserTrainingLogBusinessMapper.getSportUserTrainingLog(param.getPlayerId(), param.getDate(),
                param.getGameMode());
    }

    /**
     * 获取我的排名
     *
     * @param userId
     * @param type
     * @param year
     * @param month
     * @return
     */
    public SportUserMonthRankResponseDTO getMyRank(Long userId, Integer type, Integer year, Integer month) {
        SportUserMonthRankResponseDTO result;
        QueryWrapper<SportUserMonthRank> rankQuery = new QueryWrapper<>();
        rankQuery.eq("player_id", userId);
        rankQuery.eq("year", year);
        rankQuery.eq("month", month);
        SportUserMonthRank rank = sportUserMonthRankMapper.selectOne(rankQuery);
        if (rank == null) {
            result = new SportUserMonthRankResponseDTO();
            result.setRank(0);
            result.setScoreRank(0);
            result.setCalorieRank(0);
            result.setTotalCalorie(0);
            result.setOneMinutesFtp(BigDecimal.ZERO);
            result.setFiveMinutesFtp(BigDecimal.ZERO);
            result.setTwentyMinutesFtp(BigDecimal.ZERO);
            result.setScore(BigDecimal.ZERO);
        } else {
            result = sportUserConverter.toSportUserMonthRankResponseDTO(rank);
            Integer scoreRank = sportUserMonthRankBusinessMapper.getMyRank(1, rank.getScore(), rank.getTotalCalorie(),
                    rank.getUpdateTime(), year, month);
            Integer calorieRank = sportUserMonthRankBusinessMapper.getMyRank(2, rank.getScore(), rank.getTotalCalorie(),
                    rank.getUpdateTime(), year, month);
            result.setRank(scoreRank);
            result.setScoreRank(scoreRank);
            result.setCalorieRank(calorieRank);
        }

        SportUser user = sportUserMapper.selectById(userId);
        result.setPlayerId(userId);
        result.setAvatar(user.getAvatar());
        result.setNickname(user.getNickname());
        result.setWeight(user.getWeight());
        return result;
    }

    /**
     * 分页查询玩家排行
     *
     * @param param
     * @return
     */
    public List<SportUserMonthRankResponseDTO> geRank(SportUserMonthRankRequestDTO param) {
        Page<SportUserMonthRankResponseDTO> pageParam = new Page<>(param.getPageNo(), param.getPageSize());
        if (RankType.SCORE.equals(param.getType())) {
            pageParam.addOrder(new OrderItem("score", false));

        } else {
            pageParam.addOrder(new OrderItem("total_calorie", false));
        }
        pageParam.addOrder(new OrderItem("update_time", true));
        pageParam.addOrder(new OrderItem("t1.id", true));
        IPage<SportUserMonthRankResponseDTO> result = sportUserMonthRankBusinessMapper.getRank(pageParam, param);
        return result.getRecords();
    }

    /**
     * 查询用户运动日历
     *
     * @param userId
     * @return
     */
    public List<ScheduleResponseDTO> getSchedule(Long userId, Integer year, Integer month) {
        List<ScheduleResponseDTO> resultList = new ArrayList<>();
        Map<Integer, ScheduleResponseDTO> resultMap = new HashMap<>();
        LocalDate beginDate = LocalDate.of(year, month, 1);
        LocalDate endDate = beginDate.plusMonths(1);
        LocalDate today = LocalDate.now();
        List<ScheduleResponseDTO> trainList = sportUserTrainingLogBusinessMapper.getMonthTrainingSummary(userId,
                beginDate, endDate, today);
        trainList.forEach(item -> {
            item.setActive(true);
            item.setScheduleList(new ArrayList<>());
            resultMap.put(item.getDay(), item);
        });

        List<SimpleMatchUserScheduleVO> userScheduleList = simpleMatchBusinessMapper.getUserRegistSchedule(userId,
                beginDate, endDate, today);
        userScheduleList.forEach(item -> {
            if (!resultMap.containsKey(item.getDay())) {
                ScheduleResponseDTO scheduleResponseDTO = new ScheduleResponseDTO();
                scheduleResponseDTO.setScheduleList(new ArrayList<>());
                scheduleResponseDTO.setDay(item.getDay());
                scheduleResponseDTO.setActive(false);
                resultMap.put(item.getDay(), scheduleResponseDTO);
            }
            ScheduleVO schedule = new ScheduleVO();
            schedule.setTime(item.getTime());
            schedule.setType(GameMode.SIMPLE_MATCH);
            schedule.setTypeName("日常赛");
            resultMap.get(item.getDay()).getScheduleList().add(schedule);
        });

        List<TeamTrainingUserScheduleVO> teamTrainingUserScheduleList =
                teamTrainingBusinessMapper.getUserRegistSchedule(userId, beginDate, endDate, today);
        teamTrainingUserScheduleList.forEach(item -> {
            if (!resultMap.containsKey(item.getDay())) {
                ScheduleResponseDTO scheduleResponseDTO = new ScheduleResponseDTO();
                scheduleResponseDTO.setScheduleList(new ArrayList<>());
                scheduleResponseDTO.setDay(item.getDay());
                scheduleResponseDTO.setActive(false);
                resultMap.put(item.getDay(), scheduleResponseDTO);
            }
            ScheduleVO schedule = new ScheduleVO();
            schedule.setTime(item.getTime());
            schedule.setType(GameMode.GROUP_TRAINING);
            schedule.setTypeName("团练");
            resultMap.get(item.getDay()).getScheduleList().add(schedule);
        });

        for (Integer i = 1; i <= 31; i++) {
            if (resultMap.containsKey(i)) {
                resultList.add(resultMap.get(i));
            }
        }

        return resultList;
    }

    /**
     * 获取比赛详情
     *
     * @param id
     * @return
     */
    public TrainingDetailVO getTrainingDetail(Long id) {
        TrainingDetailVO result = sportUserTrainingLogBusinessMapper.getSportUserTrainingLogDetail(id);
        QueryWrapper<SportUserGameCurrencyLog> currencyLogQuery = new QueryWrapper<>();
        currencyLogQuery.lambda().eq(SportUserGameCurrencyLog::getSourceType, GameCurrencySourceType.SPORT)
                .eq(SportUserGameCurrencyLog::getSourceId, id);
        SportUserGameCurrencyLog currencyLog = sportUserGameCurrencyLogMapper.selectOne(currencyLogQuery);
        if (currencyLog != null) {
            result.setCurrency(currencyLog.getAmmount());
        }

        if (GameMode.SIMPLE_MATCH.equals(result.getGameMode())) {
            SimpleMatch match = simpleMatchMapper.selectById(result.getSourceId());
            if (match != null) {
                result.setEventsDistance(match.getDistance());
                result.setEventsClimbDistance(match.getClimbDistance());
            }
        }
        if (GameMode.GROUP_TRAINING.equals(result.getGameMode())) {
            TeamTraining teamTraining = teamTrainingMapper.selectById(result.getSourceId());
            if (teamTraining != null) {
                result.setEventsDistance(teamTraining.getDistance());
                result.setEventsClimbDistance(teamTraining.getClimbDistance());
            }
        }
        if (GameMode.ROOM_MODE.equals(result.getGameMode())) {
            RoomMode roomMode = roomModeMapper.selectById(result.getSourceId());
            if (roomMode != null) {
                result.setCycles(roomMode.getCycles());
                result.setRoomMode(roomMode.getMode());
                result.setEventsDistance(roomMode.getDistance());
                result.setEventsClimbDistance(roomMode.getClimbDistance());
            }
        }
        if (SportType.BICYCLE.equals(result.getSportType()) && (GameMode.SIMPLE_MATCH.equals(result.getGameMode()) || GameMode.GROUP_TRAINING.equals(result.getGameMode()) || GameMode.ROOM_MODE.equals(result.getGameMode()))) {
            result.setRankList(sportUserTrainingLogBusinessMapper.getRank(result.getGameMode(), result.getSourceId()));
        }
        return result;
    }

}
