package com.antai.sport.http.server.server.api.business.roommode.service;

import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.constants.GameMode;
import com.antai.sport.http.server.constants.RoomModeRecordStatus;
import com.antai.sport.http.server.constants.RoomModeStatus;
import com.antai.sport.http.server.constants.SportType;
import com.antai.sport.http.server.repository.roommode.entity.RoomMode;
import com.antai.sport.http.server.repository.roommode.entity.RoomModePlayerRecord;
import com.antai.sport.http.server.repository.roommode.mapper.RoomModeMapper;
import com.antai.sport.http.server.repository.roommode.mapper.RoomModePlayerRecordMapper;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.sport.mapper.SportUserMapper;
import com.antai.sport.http.server.server.api.business.roommode.converter.RoomModeConverter;
import com.antai.sport.http.server.server.api.business.roommode.dto.ReqRoomInit;
import com.antai.sport.http.server.server.api.business.roommode.dto.RespRoomInit;
import com.antai.sport.http.server.server.api.business.roommode.dto.RespRoomRank;
import com.antai.sport.http.server.server.api.business.roommode.mapper.RoomBusinessMapper;
import com.antai.sport.http.server.server.api.business.traininglog.service.SportUserTrainingLogService;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class RoomModeService {

    @Resource
    private RoomModeMapper roomModeMapper;
    @Resource
    private RoomModePlayerRecordMapper roomModePlayerRecordMapper;
    @Resource
    private SportUserMapper sportUserMapper;

    @Resource
    private RoomBusinessMapper roomBusinessMapper;

    @Resource
    private RoomModeConverter roomModeConverter;

    @Resource
    private SportUserTrainingLogService sportUserTrainingLogService;

    @Transactional
    public RespRoomInit init(ReqRoomInit initParam) {
        if (initParam.getUserIdList() == null || initParam.getUserIdList().size() == 0) {
            throw new BusinessException("没有用户加入到房间");
        }
        //初始化房间参数
        RespRoomInit resp = new RespRoomInit();
        resp.setSportType(SportType.BICYCLE);
        resp.setGameMode(GameMode.ROOM_MODE);
        RoomMode room = roomModeConverter.roomInitParamToRoomMode(initParam, RoomModeStatus.UNFINISHED);
        room.setPlayerNum(initParam.getUserIdList().size());
        roomModeMapper.insert(room);
        resp.setRoomId(room.getId());

        //初始化玩家记录
        Map<Long, Long> userRecordIdMap = new HashMap<>();
        initParam.getUserIdList().forEach(userId -> {
            RoomModePlayerRecord record = new RoomModePlayerRecord();
            record.setRoomId(room.getId());
            record.setPlayerId(userId);
            record.setStatus(RoomModeRecordStatus.UNFINISHED);
            record.setFinished(false);
            roomModePlayerRecordMapper.insert(record);
            userRecordIdMap.put(userId, record.getId());
        });

        resp.setUserRecordIdMap(userRecordIdMap);

        return resp;
    }

    /**
     * 上传数据
     *
     * @param dataList
     */
    @Transactional
    public void upload(List<CyclingDataDTO> dataList) {
        dataList.forEach(item -> {
            RoomModePlayerRecord oldRecord = roomModePlayerRecordMapper.selectById(item.getRecordId());
            if (!oldRecord.getFinished()) {
                SportUser user = sportUserMapper.selectById(oldRecord.getPlayerId());
                item.setWeight(user.getWeight());
                RoomModePlayerRecord record = roomModeConverter.toRoomModePlayerRecord(item, true);
                roomModePlayerRecordMapper.updateById(record);

                //生成骑行日志
                RoomMode roomMode = roomModeMapper.selectById(oldRecord.getRoomId());
                sportUserTrainingLogService.createBicycleTrainingLog(oldRecord.getPlayerId(), GameMode.ROOM_MODE,
                        roomMode.getId(), roomMode.getName(), roomMode.getMap(), roomMode.getPath(), 0, item);
            }
        });
    }

    /**
     * 关闭房间
     *
     * @param roomId
     */
    public void closeRoom(Long roomId) {
        RoomMode roomMode = new RoomMode();
        roomMode.setId(roomId);
        roomMode.setStatus(RoomModeStatus.FINISHED);
        roomModeMapper.updateById(roomMode);
    }

    /**
     * 获取房间排名
     *
     * @param roomId
     * @return
     */
    public List<RespRoomRank> rank(Long roomId) {
        return roomBusinessMapper.getRoomBank(roomId);
    }
}
