package com.antai.sport.http.server.server.api.business.praise.service;

import com.antai.sport.http.server.repository.base.entity.PraiseLog;
import com.antai.sport.http.server.repository.base.mapper.PraiseLogMapper;
import com.antai.sport.http.server.server.api.business.praise.converter.PraiseConverter;
import com.antai.sport.http.server.server.api.business.praise.dto.ReqPraise;
import com.antai.sport.http.server.server.api.business.user.service.SportUserSummaryService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;

@Service
public class PraiseService {
    @Resource
    private PraiseLogMapper praiseLogMapper;

    @Resource
    private PraiseConverter praiseConverter;

    @Resource
    private SportUserSummaryService sportUserSummaryService;

    /**
     * 点赞操作
     *
     * @param param
     */
    @Transactional(isolation = Isolation.READ_COMMITTED)
    public void praise(ReqPraise param) {
        PraiseLog praiseLog = praiseConverter.reqPraiseToPraiseLog(param, LocalDateTime.now());
        praiseLogMapper.insert(praiseLog);
        //更新被点赞人总点赞记录
        sportUserSummaryService.updatePraise(param.getTo(), param.getSportType());
    }

    /**
     * 查询某次游戏全部点赞数
     *
     * @param gameMode
     * @param recordId
     * @return
     */
    public Integer getPraiseByGameModeAndRecordId(Integer gameMode, Long recordId) {
        QueryWrapper<PraiseLog> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type", gameMode);
        queryWrapper.eq("record_id", recordId);
        return praiseLogMapper.selectCount(queryWrapper);
    }
}
