package com.antai.sport.http.server.mobile.api.business.train.record.controller;

import com.antai.sport.http.server.mobile.api.business.train.record.service.TrainRecordService;
import com.antai.sport.http.server.common.annotation.LoginSportUser;
import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.mobile.api.business.train.record.dto.ReqTrainRecord;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("/train/record")
@Api(tags = {"训练相关接口"})
public class TrainRecordController {
    @Resource
    private TrainRecordService trainRecordService;

    @PostMapping()
    @ApiOperation(value = "训练数据记录接口")
    public ResponseEntity<Result> saveRecord(@LoginSportUser SportUser loginUser, @RequestBody ReqTrainRecord data) {
        trainRecordService.saveRecord(loginUser,data);
        return success();
    }
}
