package com.antai.sport.http.server.mobile.api.business.app.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.mobile.api.business.app.service.AppService;
import com.antai.sport.http.server.mobile.api.business.app.vo.AppDownloadPathVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("app")
@Api(tags = {"app相关接口"})
public class AppController {
    @Resource
    private AppService appService;

    @GetMapping("download/path")
    @ApiOperation(value = "获取app下载地址")
    public ResponseEntity<Result<AppDownloadPathVO>> getAppDownloadPath() {
        return success(appService.getAppDownloadPath());
    }
}
