package com.antai.sport.http.server.team.training.leader.api.common.service;

import com.antai.sport.http.server.common.util.UUIDUtil;
import com.antai.sport.http.server.repository.sys.entity.SysUser;
import com.antai.sport.http.server.team.training.leader.api.utils.OssUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Service
public class UploadService {
    @Resource
    private OssUtils ossUtils;

    public Map<String, String> upload(MultipartFile file, SysUser loginUser) {
        Map<String, String> result = new HashMap<>();
        String originalFilename = file.getOriginalFilename();
        //获取文件类型
        String fileExtension = originalFilename.substring(originalFilename.lastIndexOf("."));
        //获取文件名
        String fileName = originalFilename.substring(0, originalFilename.lastIndexOf("."));

        String url = "";
        try {
            url = ossUtils.uploadFile(UUIDUtil.createUUID() + "-" + fileName + fileExtension, file.getBytes());

        } catch (IOException e) {
            e.printStackTrace();
        }
        result.put("url", url);
        return result;
    }
}
