package com.antai.sport.http.server.team.training.leader.api.common.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.repository.sys.entity.SysUser;
import com.antai.sport.http.server.team.training.leader.api.annotation.LoginUser;
import com.antai.sport.http.server.team.training.leader.api.common.service.UploadService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.Map;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RequestMapping("/upload")
@RestController
public class UploadController {
    @Resource
    private UploadService uploadService;

    @ResponseBody
    @PostMapping
    public ResponseEntity<Result<Map>> upload(@RequestParam("file") MultipartFile file, @LoginUser SysUser loginUser) {
        return success(uploadService.upload(file, loginUser));
    }
}
