package com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

@Data
@ApiModel("日常赛列表查询条件")
public class TeamTrainingListRequestDTO {
    private Integer pageNo;
    private Integer pageSize;
    private String sortField;
    private String sortOrder;
    @ApiModelProperty("比赛名称")
    private String name;
    @ApiModelProperty("比赛开始时间查询:开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate beginDate;
    @ApiModelProperty("比赛开始时间查询:结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate endDate;
}
