package com.antai.sport.http.server.server.api.common.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.common.service.UploadService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.Map;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RequestMapping("/upload")
@RestController
@Api(tags = {"文件上传"})
public class UploadController {
    @Resource
    private UploadService uploadService;

    @ResponseBody
    @PostMapping(value = "/{playerId}")
    @ApiOperation("fit文件上传")
    public ResponseEntity<Result<Map>> upload(@ApiParam(value = "file", required = true) @RequestParam("file") MultipartFile file, @PathVariable Long playerId) {
        return success(uploadService.upload(file, playerId));
    }
}
