package com.antai.sport.http.server.server.api.business.teamtraining.converter;

import com.antai.sport.http.server.repository.teamtraining.entity.TeamTraining;
import com.antai.sport.http.server.repository.teamtraining.entity.TeamTrainingBanner;
import com.antai.sport.http.server.repository.teamtraining.entity.TeamTrainingPlayerRecord;
import com.antai.sport.http.server.server.api.business.teamtraining.dto.TeamTrainingBannerResponseDTO;
import com.antai.sport.http.server.server.api.business.teamtraining.dto.TeamTrainingInfoResponseDTO;
import com.antai.sport.http.server.server.api.business.teamtraining.dto.TeamTrainingRecordUploadDTO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

import java.util.List;

@Mapper(componentModel = "spring")
public interface TeamTrainingConverter {

    List<TeamTrainingBannerResponseDTO> toTeamTrainingBannerResponseDTO(List<TeamTrainingBanner> source);

    TeamTrainingInfoResponseDTO toTeamTrainingInfoResponseDTO(TeamTraining source);

    @Mappings({
            @Mapping(source = "source.matchRank", target = "trainingRank"),
            @Mapping(source = "source.recordId", target = "id"),
            @Mapping(source = "finished", target = "finished")

    })
    TeamTrainingPlayerRecord toTeamTrainingPlayerRecord(TeamTrainingRecordUploadDTO source, Boolean finished);
}
