package com.antai.sport.http.server.server.api.business.teamtraining.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.teamtraining.dto.*;
import com.antai.sport.http.server.server.api.business.teamtraining.service.TeamTrainingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RequestMapping("/team/training")
@RestController
@Api(tags = {"团练接口"})
public class TeamTrainingController {
    @Resource
    private TeamTrainingService teamTrainingService;

    @ApiOperation("获取banner地址")
    @GetMapping("/banner/list")
    public ResponseEntity<Result<List<TeamTrainingBannerResponseDTO>>> getTeamTrainingBannerList() {
        return success(teamTrainingService.getTeamTrainingBannerList());
    }

    @ApiOperation("查询所有未完团练列表")
    @GetMapping("/list")
    public ResponseEntity<Result<List<TeamTrainingForListResponseDTO>>> getUnFinishedTeamTrainingForServer() {
        return success(teamTrainingService.getUnFinishedTeamTrainingForServer());
    }

    @ApiOperation("通过用户id查询未完团练列表")
    @GetMapping("/list/user/{userId}")
    public ResponseEntity<Result<List<TeamTrainingForListResponseDTO>>> getUnFinishedTeamTrainingForUser(@PathVariable("userId") Long userId) {
        return success(teamTrainingService.getUnFinishedTeamTrainingForUser(userId));
    }

    @ApiOperation("团练报名")
    @PostMapping("/regist")
    public ResponseEntity<Result> register(@RequestBody TeamTrainingRegistRequestDTO param) {
        teamTrainingService.regist(param);
        return success();
    }

    @ApiOperation("查询团练明细")
    @PostMapping("/info")
    public ResponseEntity<Result<TeamTrainingInfoResponseDTO>> teamTrainingInfo(@RequestBody TeamTrainingInfoRequestDTO param) {
        return success(teamTrainingService.teamTrainingInfo(param));
    }


    @ApiOperation("获取团练报名人信息")
    @PostMapping("/{teamTrainingId}/register/list")
    public ResponseEntity<Result<List<Long>>> getRegisterList(@PathVariable("teamTrainingId") Long teamTrainingId) {
        return success(teamTrainingService.getRegisterList(teamTrainingId));
    }

    @ApiOperation("查询日团练排名")
    @GetMapping("/rank/{teamTrainingId}")
    public ResponseEntity<Result<List<TeamTrainingRankDTO>>> rank(@PathVariable("teamTrainingId") Long teamTrainingId) {
        return success(teamTrainingService.rank(teamTrainingId));
    }

    @ApiOperation("玩家加入团练数据初始化")
    @PostMapping("/record/init")
    public ResponseEntity<Result<TeamTrainingPlayerRecordInitResponseDTO>> recordInit(@RequestBody TeamTrainingPlayerRecordInitRequestDTO param) {
        return success(teamTrainingService.recordInit(param));
    }

    @ApiOperation("团练记录上传")
    @PostMapping("/record/upload")
    public ResponseEntity<Result> recordUpload(@RequestBody List<TeamTrainingRecordUploadDTO> dataList) {
        teamTrainingService.recordUpload(dataList);
        return success();
    }

}
