package com.antai.sport.http.server.server.api.business.series.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@ApiModel("系列赛详情")
@Data
public class SeriesDetailsVO {
    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("名称")
    private String name;
    @ApiModelProperty("描述")
    private String description;
    @ApiModelProperty("协议")
    private String agreement;
    @ApiModelProperty("状态 10 报名中 20 进行中 30 未开赛 40 已完赛")
    private Integer status;
    @ApiModelProperty("报名开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private LocalDateTime applyStartTime;
    @ApiModelProperty("报名结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private LocalDateTime applyEndTime;
    @ApiModelProperty("报名数量")
    private Integer applyNum;
    @ApiModelProperty("玩家报名赛区 null 为未报名")
    private Long areaId;
    @ApiModelProperty("是否已报名 true 报名 false 未报名")
    private Boolean applied;
    @ApiModelProperty("通知列表")
    List<SeriesNoticeVO> noticeList;
    @ApiModelProperty("轮次列表")
    List<SeriesRoundVO> roundList;
    @ApiModelProperty("赛区列表")
    List<SeriesAreaVO> areaList;
}
