package com.antai.sport.http.server.server.api.business.course.service;

import com.antai.sport.http.server.common.service.CommonCodeService;
import com.antai.sport.http.server.common.vo.SysCodeDetailVO;
import com.antai.sport.http.server.constants.*;
import com.antai.sport.http.server.repository.course.entity.Course;
import com.antai.sport.http.server.repository.course.entity.CourseRecord;
import com.antai.sport.http.server.repository.course.mapper.CourseMapper;
import com.antai.sport.http.server.repository.course.mapper.CourseRecordMapper;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.sport.mapper.SportUserMapper;
import com.antai.sport.http.server.server.api.business.course.converter.CourseRecordConverter;
import com.antai.sport.http.server.server.api.business.course.dto.CourseRecordInitDTO;
import com.antai.sport.http.server.server.api.business.course.mapper.CourseBusinessMapper;
import com.antai.sport.http.server.server.api.business.course.vo.CourseItemVO;
import com.antai.sport.http.server.server.api.business.course.vo.CourseRecordInitVO;
import com.antai.sport.http.server.server.api.business.course.vo.CourseTypeVO;
import com.antai.sport.http.server.server.api.business.course.vo.CourseVO;
import com.antai.sport.http.server.server.api.business.praise.service.PraiseService;
import com.antai.sport.http.server.server.api.business.traininglog.service.SportUserTrainingLogService;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class CourseService {
    @Resource
    private CommonCodeService commonCodeService;
    @Resource
    private CourseBusinessMapper courseBusinessMapper;
    @Resource
    private CourseMapper courseMapper;
    @Resource
    private CourseRecordMapper courseRecordMapper;
    @Resource
    private SportUserMapper sportUserMapper;

    @Resource
    private CourseRecordConverter courseRecordConverter;

    @Resource
    private PraiseService praiseService;
    @Resource
    private SportUserTrainingLogService sportUserTrainingLogService;

    public List<CourseTypeVO> getCourseTree() {
        List<CourseTypeVO> resultList = new ArrayList<>();
        List<CourseVO> courseList = courseBusinessMapper.getCourseList();
        if (!courseList.isEmpty()) {
            Map<String, List<SysCodeDetailVO>> codeMap = commonCodeService.getCodeByTypes(CourseType.CODE);
            List<SysCodeDetailVO> courseTypeList = codeMap.get(CourseType.CODE);
            Map<Integer, CourseTypeVO> courseTypeMap = new HashMap<>();
            for (SysCodeDetailVO item : courseTypeList) {
                CourseTypeVO courseType = new CourseTypeVO();
                courseType.setName(item.getName());
                courseType.setCourseList(new ArrayList<>());
                courseTypeMap.put(item.getValue(), courseType);
                resultList.add(courseType);
            }
            for (CourseVO course : courseList) {
                if (courseTypeMap.containsKey(course.getType())) {
                    courseTypeMap.get(course.getType()).getCourseList().add(course);
                }
            }
        }
        return resultList;
    }

    public List<CourseItemVO> getCourseItemList(Long courseId) {
        return courseBusinessMapper.getCourseItemList(courseId);
    }

    /**
     * 初始化漫游记录
     *
     * @param initData
     * @return
     */
    public CourseRecordInitVO init(CourseRecordInitDTO initData) {
        CourseRecordInitVO resp = new CourseRecordInitVO();
        CourseRecord record = new CourseRecord();
        record.setPlayerId(initData.getPlayerId());
        record.setMap(initData.getMap());
        record.setPath(initData.getPath());
        record.setCreateTime(LocalDateTime.now());
        record.setStatus(TourRecordStatus.UNCOMMITTED);
        record.setCourseId(initData.getCourseId());
        Course course = courseMapper.selectById(initData.getCourseId());
        record.setCourseName(course.getName());
        courseRecordMapper.insert(record);

        resp.setRecordId(record.getId());
        resp.setSportType(SportType.BICYCLE);
        resp.setGameMode(GameMode.COURSE_TRAINING);
        return resp;
    }

    /**
     * 课程训练记录上传
     *
     * @param recordList
     */
    @Transactional
    public void upload(List<CyclingDataDTO> recordList) {
        recordList.forEach(item -> {
            CourseRecord oldRecord = courseRecordMapper.selectById(item.getRecordId());
            if (oldRecord != null && oldRecord.getStatus().equals(CourseRecordStatus.UNCOMMITTED)) {
                SportUser user = sportUserMapper.selectById(oldRecord.getPlayerId());
                item.setWeight(user.getWeight());
                CourseRecord record = courseRecordConverter.convertToCourseRecord(item, CourseRecordStatus.COMMITTED);
                record.setPraiseNum(praiseService.getPraiseByGameModeAndRecordId(GameMode.COURSE_TRAINING,
                        item.getRecordId()));
                courseRecordMapper.updateById(record);

                //生成骑行日志
                sportUserTrainingLogService.createBicycleTrainingLog(oldRecord.getPlayerId(),
                        GameMode.COURSE_TRAINING, oldRecord.getId(), oldRecord.getCourseName(), oldRecord.getMap(),
                        oldRecord.getPath(), record.getPraiseNum(), item);
            }
        });
    }
}
