package com.antai.sport.http.server.server.api.business.course.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.course.dto.CourseRecordInitDTO;
import com.antai.sport.http.server.server.api.business.course.service.CourseService;
import com.antai.sport.http.server.server.api.business.course.vo.CourseItemVO;
import com.antai.sport.http.server.server.api.business.course.vo.CourseRecordInitVO;
import com.antai.sport.http.server.server.api.business.course.vo.CourseTypeVO;
import com.antai.sport.http.server.server.api.business.tour.dto.ReqTourRecordInit;
import com.antai.sport.http.server.server.api.business.tour.dto.RespTourRecordInit;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("course")
@Api(tags = {"课程训练接口"})
public class CourseController {

    @Resource
    private CourseService courseService;

    @GetMapping("tree")
    @ApiOperation(value = "课程树")
    public ResponseEntity<Result<List<CourseTypeVO>>> getCourseTree() {
        return success(courseService.getCourseTree());
    }

    @GetMapping("/{courseId}")
    @ApiOperation(value = "获取课程章节")
    public ResponseEntity<Result<List<CourseItemVO>>> getCourseItemList(@PathVariable("courseId") Long courseId) {
        return success(courseService.getCourseItemList(courseId));
    }

    @ApiOperation("初始化课程训练记录")
    @PostMapping("/init")
    public ResponseEntity<Result<CourseRecordInitVO>> init(@RequestBody CourseRecordInitDTO initData) {
        return success(courseService.init(initData));
    }


    @ApiOperation(value = "课程训练记录上传")
    @PostMapping("/record/upload")
    public ResponseEntity<Result> recordUpload(@RequestBody List<CyclingDataDTO> dataList) {
        courseService.upload(dataList);
        return success();
    }
}
