package com.antai.sport.http.server.server.api.business.club.mapper;

import com.antai.sport.http.server.server.api.business.club.dto.ClubListReqDTO;
import com.antai.sport.http.server.server.api.business.club.dto.ClubRespDTO;
import com.antai.sport.http.server.server.api.business.club.dto.vo.ClubMemberVO;
import com.antai.sport.http.server.server.api.business.club.dto.vo.ClubNoticeVO;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface ClubBusinessMapper {

    /**
     * 检测俱乐部名称是否重复
     *
     * @param id
     * @param name
     * @return
     */
    Boolean checkClubNameRepeat(@Param("id") Long id, @Param("name") String name);

    /**
     * 验证当前玩家是否已经是俱乐部会长
     *
     * @param playerId
     * @return
     */
    Boolean checkChairman(@Param("playerId") Long playerId);

    /**
     * 查询俱乐部列表
     *
     * @param page
     * @param param
     * @return
     */
    IPage<ClubRespDTO> getClubList(IPage<ClubRespDTO> page, @Param("param") ClubListReqDTO param);

    /**
     * 查询俱乐部信息
     *
     * @param clubId
     * @return
     */
    ClubRespDTO getClubInfo(@Param("clubId") Long clubId, @Param("param") Object param);

    /**
     * 查询俱乐部通知
     *
     * @param clubId
     * @return
     */
    List<ClubNoticeVO> getClubNotice(@Param("clubId") Long clubId);

    /**
     * 获取俱乐部成员列表
     *
     * @param clubId
     * @return
     */
    List<ClubMemberVO> getClubMemberList(@Param("clubId") Long clubId);

}
