package com.antai.sport.http.server.server.api.business.base.service;

import com.antai.sport.http.server.repository.base.entity.GameMode;
import com.antai.sport.http.server.repository.base.mapper.GameModeMapper;
import com.antai.sport.http.server.server.api.business.base.dto.AppLatestVersionVO;
import com.antai.sport.http.server.server.api.business.base.dto.AreaRespDTO;
import com.antai.sport.http.server.server.api.business.base.mapper.BaseBusinessMapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class BaseService {
    @Resource
    private GameModeMapper gameModeMapper;
    @Resource
    private BaseBusinessMapper baseBusinessMapper;

    public List<GameMode> getGameMode() {
        return gameModeMapper.selectList(null);
    }

    public List<AreaRespDTO> getArea(Long parentId) {
        return baseBusinessMapper.getArea(parentId);
    }

    public AppLatestVersionVO getAppLatestVersion(Integer clientType) {
        return baseBusinessMapper.getAppLatestVersion(clientType);
    }
}
