package com.antai.sport.http.server.server.api.business.achievement.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.achievement.dto.AchievementHomeVO;
import com.antai.sport.http.server.server.api.business.achievement.dto.NewAchievementVO;
import com.antai.sport.http.server.server.api.business.achievement.service.AchievementService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("achievement")
@Api(tags = {"成就接口"})
public class AchievementController {
    @Resource
    private AchievementService achievementService;

    @ApiOperation(value = "查询用户新成就")
    @GetMapping("/new/{sportUserId}")
    public ResponseEntity<Result<List<NewAchievementVO>>> getNewAchievement(@PathVariable("sportUserId") Long sportUserId) {
        return success(achievementService.getNewAchievement(sportUserId));
    }

    @ApiOperation(value = "查询用户成就主页")
    @GetMapping("/home/{sportUserId}")
    public ResponseEntity<Result<AchievementHomeVO>> getUserAchievementHome(@PathVariable("sportUserId") Long sportUserId) {
        return success(achievementService.getUserAchievementHome(sportUserId));
    }
}
