package com.antai.sport.http.server.repository.series.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-09-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SeriesMatchPlayerRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 系列赛id
     */
    private Long seriesId;

    /**
     * 轮次id
     */
    private Long roundId;

    /**
     * 比赛id
     */
    private Long matchId;

    /**
     * 玩家id
     */
    private Long playerId;

    /**
     * 比赛进入时间
     */
    private LocalDateTime entryTime;

    /**
     * 比赛完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 比赛用时(秒)
     */
    private Integer duration;

    /**
     * 比赛名次
     */
    private Integer matchRank;

    /**
     * 骑行总长度
     */
    private BigDecimal distance;

    /**
     * 爬坡距离
     */
    private BigDecimal climbDistance;

    /**
     * 平均功率
     */
    private BigDecimal avgFtp;

    /**
     * 平均速度
     */
    private BigDecimal avgSpeed;

    /**
     * 卡路里
     */
    private Integer calorie;

    /**
     * 体重
     */
    private BigDecimal weight;

    /**
     * 1分钟平均最佳FTP
     */
    private BigDecimal oneMinutesFtp;

    /**
     * 5分钟平均最佳FTP
     */
    private BigDecimal fiveMinutesFtp;

    /**
     * 20分钟平均最佳FTP
     */
    private BigDecimal twentyMinutesFtp;

    /**
     * 1分钟平均最佳功体比
     */
    private BigDecimal oneMinutesWkg;

    /**
     * 5分钟平均最佳功体比
     */
    private BigDecimal fiveMinutesWkg;

    /**
     * 20分钟平均最佳功体比
     */
    private BigDecimal twentyMinutesWkg;

    /**
     * 得分
     */
    private BigDecimal score;

    /**
     * 获攒数量
     */
    private Integer praiseNum;

    /**
     * 比赛状态10:未完成比赛 20:完成比赛
     */
    private Integer status;

    /**
     * 成绩确认状态 10 待确认 20 无效 30已确认未晋级 40晋级
     */
    private Integer resultConfirmStatus;

    /**
     * 是否结束
     */
    private Boolean finished;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


}
