package com.antai.sport.http.server.repository.course.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-08-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CourseItem implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 课程id
     */
    private Long courseId;

    /**
     * 章节名称
     */
    private String name;

    /**
     * 指标类型 1:ftp 2:踏频 3:速度
     */
    private Integer targetType;

    /**
     * 目标值类型
     */
    private Integer targetValueType;

    /**
     * 目标值
     */
    private BigDecimal targetValue;

    /**
     * 允许偏差
     */
    private BigDecimal allowableDeviation;

    /**
     * 持续时长s
     */
    private Integer duration;

    /**
     * 描述
     */
    private String description;

    /**
     * 显示顺序
     */
    private Integer showOrder;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改人
     */
    private Long updateBy;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


}
