package com.antai.sport.http.server.repository.club.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-07-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class Club implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 俱乐部名称
     */
    private String name;

    /**
     * logo
     */
    private String logo;

    /**
     * 描述
     */
    private String description;

    /**
     * 省
     */
    private Long province;

    /**
     * 市
     */
    private Long city;

    /**
     * 会长id
     */
    private Long chairmanId;

    /**
     * 会员数量
     */
    private Integer memberNumber;

    /**
     * 总爬坡高度
     */
    private BigDecimal totalClimbDistance;

    /**
     * 总骑行距离
     */
    private BigDecimal totalDistance;

    /**
     * 总持续时长
     */
    private Integer totalDuration;

    /**
     * 卡路里
     */
    private Integer totalCalorie;

    /**
     * 俱乐部创建时间
     */
    private LocalDate clubCreateTime;

    /**
     * 创建人id
     */
    private Long createUser;

    /**
     * 数据创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


}
