package com.antai.sport.http.server.management.api.common.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.management.api.annotation.LoginUser;
import com.antai.sport.http.server.management.api.common.service.UploadService;
import com.antai.sport.http.server.repository.sys.entity.SysUser;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;

import java.util.Map;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RequestMapping("/upload")
@RestController
public class UploadController {
    @Resource
    private UploadService uploadService;

    @ResponseBody
    @PostMapping
    public ResponseEntity<Result<Map>> upload(@RequestParam("file") MultipartFile file, @LoginUser SysUser loginUser) {
        return success(uploadService.upload(file, loginUser));
    }
}
