package com.antai.sport.http.server.team.training.leader.api.business.teamtraining.service;

import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.constants.DeleteStatus;
import com.antai.sport.http.server.repository.map.entity.Map;
import com.antai.sport.http.server.repository.map.entity.MapPath;
import com.antai.sport.http.server.repository.map.mapper.MapMapper;
import com.antai.sport.http.server.repository.map.mapper.MapPathMapper;
import com.antai.sport.http.server.repository.teamtraining.entity.TeamTraining;
import com.antai.sport.http.server.repository.teamtraining.entity.TeamTrainingLeader;
import com.antai.sport.http.server.repository.teamtraining.mapper.TeamTrainingMapper;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.converter.TeamTrainingConverter;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto.TeamTrainingListRequestDTO;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto.TeamTrainingListResponseDTO;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto.TeamTrainingResponseDTO;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto.vo.MapPathVO;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto.vo.TeamTrainingListVO;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto.vo.TeamTrainingVO;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.mapper.TeamTrainingBusinessMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Service
public class TeamTrainingService {
    @Resource
    private TeamTrainingMapper teamTrainingMapper;
    @Resource
    private TeamTrainingBusinessMapper teamTrainingBusinessMapper;
    @Resource
    private MapMapper mapMapper;
    @Resource
    private MapPathMapper mapPathMapper;
    @Resource
    private TeamTrainingConverter teamTrainingConverter;
    @Resource
    private TeamTrainingChangeNotifyService teamTrainingChangeNotifyService;

    public TeamTrainingListResponseDTO getTrainingList(TeamTrainingListRequestDTO param, TeamTrainingLeader loginUser) {
        Page<TeamTrainingListVO> pageParam = new Page<>(param.getPageNo(), param.getPageSize());
        if (StringUtils.isNotEmpty(param.getSortOrder())) {
            pageParam.addOrder(new OrderItem("start_time", "asc".equals(param.getSortOrder())));
        }
        pageParam.addOrder(new OrderItem("id", false));
        IPage<TeamTrainingListVO> result = teamTrainingBusinessMapper.getTrainingList(pageParam, param , loginUser.getId());

        TeamTrainingListResponseDTO dto = new TeamTrainingListResponseDTO();
        dto.setData(result.getRecords());
        dto.setPageNo(param.getPageNo());
        dto.setTotalCount(result.getTotal());
        return dto;
    }

    public void delete(Long trainingId) {
        TeamTraining teamTraining = teamTrainingMapper.selectById(trainingId);
        if (teamTraining.getStatus() != null && teamTraining.getStatus().equals(20)) {
            throw new BusinessException("已发布比赛不能删除");
        }
        teamTraining.setDeleted(Integer.valueOf(DeleteStatus.DELETED));
        teamTrainingMapper.updateById(teamTraining);
    }

    public void publish(Long trainingId) {
        TeamTraining teamTraining = teamTrainingMapper.selectById(trainingId);
        if (teamTraining.getStatus() == null || teamTraining.getStatus().equals(10)) {
            teamTraining.setStatus(20);
        } else {
            teamTraining.setStatus(10);
        }
        teamTrainingMapper.updateById(teamTraining);
        teamTrainingChangeNotifyService.notifyGameServerTeamTrainingChange();
    }

    public TeamTrainingResponseDTO getTraining(Long trainingId) {
        TeamTrainingResponseDTO result = new TeamTrainingResponseDTO();
        TeamTraining training;
        if (trainingId == null || trainingId == 0) {
            training = new TeamTraining();
            training.setStatus(10);
        } else {
            training = teamTrainingMapper.selectById(trainingId);
            if (training == null) {
                throw new BusinessException("您查询的比赛不存在");
            }
        }
        TeamTrainingVO teamTrainingVO = teamTrainingConverter.toTeamTrainingVO(training);
        result.setTraining(teamTrainingVO);
        List<Map> mapList = mapMapper.selectList(null);
        List<MapPath> mapPathList = mapPathMapper.selectList(null);
        HashMap<String, MapPathVO> mapPathVOHashMap = new HashMap<>();
        List<MapPathVO> mapPathVOList = new ArrayList<>(mapList.size());
        mapList.forEach(item -> {
            MapPathVO mapVO = new MapPathVO();
            mapVO.setId(item.getId());
            mapVO.setKey(item.getMapKey());
            mapVO.setName(item.getMapName());
            mapVO.setPathList(new ArrayList<>());
            mapPathVOList.add(mapVO);
            mapPathVOHashMap.put(item.getMapKey(), mapVO);
        });
        mapPathList.forEach(item -> {
            MapPathVO mapPathVO = new MapPathVO();
            mapPathVO.setId(item.getId());
            mapPathVO.setKey(item.getPathKey());
            mapPathVO.setName(item.getPathName());
            if (mapPathVOHashMap.containsKey(item.getMapKey())) {
                mapPathVOHashMap.get(item.getMapKey()).getPathList().add(mapPathVO);
            }
        });
        result.setMapList(mapPathVOList);
        return result;
    }

    public void save(TeamTrainingVO teamTrainingVO, TeamTrainingLeader loginUser) {
        TeamTraining training = teamTrainingConverter.toTeamTraining(teamTrainingVO);
        if (training.getId() != null && training.getId() > 0) {
            teamTrainingMapper.updateById(training);
        } else {
            training.setStatus(10);
            training.setLeaderId(loginUser.getId());
            teamTrainingMapper.insert(training);
        }
        teamTrainingChangeNotifyService.notifyGameServerTeamTrainingChange();
    }

}
