package com.antai.sport.http.server.team.training.leader.api.business.teamtraining.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.repository.teamtraining.entity.TeamTrainingLeader;
import com.antai.sport.http.server.team.training.leader.api.annotation.LoginUser;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto.TeamTrainingListRequestDTO;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto.TeamTrainingListResponseDTO;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto.TeamTrainingResponseDTO;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.dto.vo.TeamTrainingVO;
import com.antai.sport.http.server.team.training.leader.api.business.teamtraining.service.TeamTrainingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("/team/training")
@Api(tags = {"日常赛"})
public class TeamTrainingController {

    @Resource
    private TeamTrainingService teamTrainingService;

    @ApiOperation("加载团练列表")
    @PostMapping("list")
    public ResponseEntity<Result<TeamTrainingListResponseDTO>> getMatchList(@RequestBody TeamTrainingListRequestDTO param, @LoginUser TeamTrainingLeader loginUser) {
        return success(teamTrainingService.getTrainingList(param, loginUser));
    }

    @ApiOperation("删除")
    @DeleteMapping("/{trainingId}")
    public ResponseEntity<Result> deleteMatch(@PathVariable("trainingId") Long trainingId) {
        teamTrainingService.delete(trainingId);
        return success();
    }

    @ApiOperation("更改发布状态")
    @PutMapping("/{trainingId}")
    public ResponseEntity<Result> publish(@PathVariable("trainingId") Long trainingId) {
        teamTrainingService.publish(trainingId);
        return success();
    }

    @ApiOperation("获取团练数据")
    @GetMapping("/{trainingId}")
    public ResponseEntity<Result<TeamTrainingResponseDTO>> getSimpleMatch(@PathVariable("trainingId") Long trainingId) {
        return success(teamTrainingService.getTraining(trainingId));
    }

    @ApiOperation("创建团练")
    @PostMapping
    public ResponseEntity<Result> save(@RequestBody TeamTrainingVO teamTrainingVO, @LoginUser TeamTrainingLeader loginUser) {
        teamTrainingService.save(teamTrainingVO, loginUser);
        return success();
    }


}
