package com.antai.sport.http.server.server.api.business.series.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel("系列赛轮次")
@Data
public class SeriesRoundVO {
    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("轮次名称")
    private String name;
    @ApiModelProperty("类型 10 预选赛 20 淘汰赛")
    private Integer type;
    @ApiModelProperty("开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private LocalDateTime startTime;
    @ApiModelProperty("是否已开始")
    private Boolean started;
    @ApiModelProperty("是否已结束")
    private Boolean finished;
    @ApiModelProperty("是否已确认成绩")
    private Boolean resultConfirm;
}
