package com.antai.sport.http.server.server.api.business.series.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@ApiModel("预算赛VO")
@Data
public class SeriesQualifyingMatchVO {
    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("比赛名称")
    private String name;
    @ApiModelProperty("允许进入时间 yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime entryTime;
    @ApiModelProperty("开始比赛时间 yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime startTime;
    @ApiModelProperty("比赛结束时间 yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private LocalDateTime endTime;
    @ApiModelProperty("玩家成绩")
    private Integer result;
    @ApiModelProperty("玩家成绩(毫秒)")
    private Integer millisecond;
}
