package com.antai.sport.http.server.server.api.business.props.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.props.service.PropsService;
import com.antai.sport.http.server.server.api.business.props.vo.UserPropsVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("props")
@Api(tags = {"装备相关接口"})
public class PropsController {

    @Resource
    private PropsService propsService;

    @ApiOperation("获取用户商店首页")
    @GetMapping("/user/{sportUserId}")
    public ResponseEntity<Result<UserPropsVO>> getUserProps(@PathVariable("sportUserId") Long sportUserId) {
        return success(propsService.getUserProps(sportUserId));
    }

    @ApiOperation("购买装备")
    @GetMapping("/purchase/{sportUserId}/{propsId}")
    public ResponseEntity<Result> purchase(@PathVariable("sportUserId") Long sportUserId,
                                           @PathVariable("propsId") Long propsId) {
        propsService.purchase(sportUserId, propsId);
        return success();
    }

}
