package com.antai.sport.http.server.server.api.business.achievement.service;

import com.antai.sport.http.server.constants.*;
import com.antai.sport.http.server.repository.achievement.entity.Achievement;
import com.antai.sport.http.server.repository.achievement.entity.AchievementForSportUser;
import com.antai.sport.http.server.repository.achievement.mapper.AchievementForSportUserMapper;
import com.antai.sport.http.server.repository.achievement.mapper.AchievementMapper;
import com.antai.sport.http.server.repository.sport.entity.SportUserContinuousLoginDays;
import com.antai.sport.http.server.repository.sport.entity.SportUserSummary;
import com.antai.sport.http.server.repository.sport.mapper.SportUserContinuousLoginDaysMapper;
import com.antai.sport.http.server.repository.sport.mapper.SportUserSummaryMapper;
import com.antai.sport.http.server.server.api.business.achievement.dto.AchievementHomeItemVO;
import com.antai.sport.http.server.server.api.business.achievement.dto.AchievementHomeVO;
import com.antai.sport.http.server.server.api.business.achievement.dto.NewAchievementVO;
import com.antai.sport.http.server.server.api.business.achievement.mapper.AchievementBizMapper;
import com.antai.sport.http.server.server.api.business.sportusergamecurrency.service.SportUserGameCurrencyService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class AchievementService {

    @Resource
    private AchievementMapper achievementMapper;
    @Resource
    private AchievementForSportUserMapper achievementForSportUserMapper;
    @Resource
    private SportUserContinuousLoginDaysMapper sportUserContinuousLoginDaysMapper;
    @Resource
    private SportUserSummaryMapper sportUserSummaryMapper;

    @Resource
    private AchievementBizMapper achievementBizMapper;

    @Resource
    private SportUserGameCurrencyService sportUserGameCurrencyService;

    /**
     * 处理签到类成就
     *
     * @param sportUserId
     */
    public void handleSignInAchievement(Long sportUserId, Integer continuousLoginDays) {
        this.initAchievement(sportUserId, AchievementCondition.SIGN_IN_DAYS, continuousLoginDays);
    }

    /**
     * 处理运动类成就
     * 先完成业务后面再考虑性能优化
     *
     * @param gameMode
     * @param summary
     */
    public void handleSportAchievement(Integer gameMode, SportUserSummary summary) {
        if (gameMode.equals(GameMode.GROUP_TRAINING)) {
            initAchievement(summary.getUserId(), AchievementCondition.TEAM_TRAINING,
                    summary.getTotalTeamTrainingFinishNum());
        }
        if (gameMode.equals(GameMode.SIMPLE_MATCH)) {
            initAchievement(summary.getUserId(), AchievementCondition.SIMPLE_MATCH,
                    summary.getTotalSimpleMatchFinishNum());
        }
        if (gameMode.equals(GameMode.ROOM_MODE)) {
            initAchievement(summary.getUserId(), AchievementCondition.ROOM_MODE, summary.getTotalGameModeFinishNum());
        }
        initAchievement(summary.getUserId(), AchievementCondition.DISTANCE, summary.getTotalDistance().intValue());
        initAchievement(summary.getUserId(), AchievementCondition.CLIMB_DISTANCE,
                summary.getTotalClimbDistance().intValue());
        initAchievement(summary.getUserId(), AchievementCondition.CALORIE, summary.getTotalCalorie() / 1000);


    }

    /**
     * 成就计算和积分操作
     *
     * @param sportUserId
     * @param condition
     * @param conditionValue
     */
    private void initAchievement(Long sportUserId, Integer condition, Integer conditionValue) {
        if (conditionValue == null) {
            return;
        }
        List<Achievement> achievementList = achievementBizMapper.getAchievement(condition, sportUserId);
        for (Achievement achievement : achievementList) {
            if (conditionValue.compareTo(achievement.getConditionValue()) >= 0) {
                AchievementForSportUser achievementForSportUser = new AchievementForSportUser();
                achievementForSportUser.setSportUserId(sportUserId);
                achievementForSportUser.setAchievementId(achievement.getId());
                achievementForSportUser.setMarkRead(false);
                achievementForSportUser.setCreateTime(LocalDateTime.now());
                achievementForSportUserMapper.insert(achievementForSportUser);
                String description = "达成成就：" + achievement.getAchievementName();
                sportUserGameCurrencyService.addCurrency(sportUserId, achievement.getCurrency(),
                        GameCurrencySourceType.ACHIEVEMENT, achievementForSportUser.getId(), description);
            }
        }
    }

    /**
     * 查询用户新成就
     *
     * @param sportUserId
     * @return
     */
    public List<NewAchievementVO> getNewAchievement(Long sportUserId) {
        List<NewAchievementVO> achievementVOList = achievementBizMapper.getNewAchievement(sportUserId);
        if (!achievementVOList.isEmpty()) {
            achievementBizMapper.updateReadAchievement(achievementVOList);
        }
        return achievementVOList;
    }

    /**
     * 查询用户成就主页
     *
     * @param sportUserId
     * @return
     */
    public AchievementHomeVO getUserAchievementHome(Long sportUserId) {
        AchievementHomeVO result = new AchievementHomeVO();
        result.setMyAchievementNum(0);
        result.setBaseAchievementList(new ArrayList<>());
        result.setAdvancedAchievementList(new ArrayList<>());
        result.setMasterAchievementList(new ArrayList<>());

        QueryWrapper<Achievement> achievementQuery = new QueryWrapper<>();
        achievementQuery.lambda().eq(Achievement::getDeleted, DeleteStatus.UNDELETED).orderBy(true, true,
                Achievement::getShowOrder);
        List<Achievement> achievementList = achievementMapper.selectList(achievementQuery);
        result.setTotalAchievementNum(achievementList.size());

        QueryWrapper<AchievementForSportUser> myAchievementQuery = new QueryWrapper<>();
        myAchievementQuery.lambda().eq(AchievementForSportUser::getSportUserId, sportUserId);
        List<AchievementForSportUser> myAchievementList = achievementForSportUserMapper.selectList(myAchievementQuery);

        Map<Long, AchievementForSportUser> myAchievementMap = new HashMap<>();
        for (AchievementForSportUser myAchievement : myAchievementList) {
            myAchievementMap.put(myAchievement.getAchievementId(), myAchievement);
        }

        QueryWrapper<SportUserContinuousLoginDays> continuousLoginDaysQuery = new QueryWrapper<>();
        continuousLoginDaysQuery.lambda().eq(SportUserContinuousLoginDays::getSportUserId, sportUserId);
        SportUserContinuousLoginDays continuousLoginDays =
                sportUserContinuousLoginDaysMapper.selectOne(continuousLoginDaysQuery);

        QueryWrapper<SportUserSummary> summaryQuery = new QueryWrapper<>();
        summaryQuery.lambda().eq(SportUserSummary::getUserId, sportUserId);
        SportUserSummary summary = sportUserSummaryMapper.selectOne(summaryQuery);


        for (Achievement achievement : achievementList) {
            AchievementHomeItemVO homeItem = new AchievementHomeItemVO();
            homeItem.setAchievementName(achievement.getAchievementName());
            homeItem.setRemark(achievement.getRemark());
            homeItem.setPercent(BigDecimal.ZERO);
            if (myAchievementMap.containsKey(achievement.getId())) {
                homeItem.setPercent(BigDecimal.ONE);
                homeItem.setAwarded(true);
                homeItem.setLogo(achievement.getLogo());
                homeItem.setCreateTime(myAchievementMap.get(achievement.getId()).getCreateTime());
                result.setMyAchievementNum(result.getMyAchievementNum() + 1);
            } else {
                homeItem.setAwarded(false);
                homeItem.setLogo(achievement.getDefaultLogo());
                //计算百分比
                //计算签到
                if (achievement.getAchievementCondition().equals(AchievementCondition.SIGN_IN_DAYS)) {
                    if (continuousLoginDays != null) {
                        homeItem.setPercent(this.calcPercent(continuousLoginDays.getDays(),
                                achievement.getConditionValue()));
                    }
                }
                //计算团练成就
                if (summary != null) {
                    if (achievement.getAchievementCondition().equals(AchievementCondition.TEAM_TRAINING)) {
                        homeItem.setPercent(this.calcPercent(summary.getTotalTeamTrainingFinishNum(),
                                achievement.getConditionValue()));
                    }
                    if (achievement.getAchievementCondition().equals(AchievementCondition.SIMPLE_MATCH)) {
                        homeItem.setPercent(this.calcPercent(summary.getTotalSimpleMatchFinishNum(),
                                achievement.getConditionValue()));
                    }
                    if (achievement.getAchievementCondition().equals(AchievementCondition.ROOM_MODE)) {
                        homeItem.setPercent(this.calcPercent(summary.getTotalGameModeFinishNum(),
                                achievement.getConditionValue()));
                    }
                    if (achievement.getAchievementCondition().equals(AchievementCondition.DISTANCE)) {
                        homeItem.setPercent(this.calcPercent(summary.getTotalDistance().intValue(),
                                achievement.getConditionValue()));
                    }
                    if (achievement.getAchievementCondition().equals(AchievementCondition.CLIMB_DISTANCE)) {
                        homeItem.setPercent(this.calcPercent(summary.getTotalClimbDistance().intValue(),
                                achievement.getConditionValue()));
                    }
                    if (achievement.getAchievementCondition().equals(AchievementCondition.CALORIE)) {
                        homeItem.setPercent(this.calcPercent(summary.getTotalCalorie()/1000,
                                achievement.getConditionValue()));
                    }
                }
            }
            if (achievement.getLevel().equals(AchievementLevel.BASE)) {
                result.getBaseAchievementList().add(homeItem);
            }
            if (achievement.getLevel().equals(AchievementLevel.ADVANCED)) {
                result.getAdvancedAchievementList().add(homeItem);
            }
            if (achievement.getLevel().equals(AchievementLevel.MASTER)) {
                result.getMasterAchievementList().add(homeItem);
            }
        }

        return result;
    }

    private BigDecimal calcPercent(Integer molecule, Integer denominator) {
        if (molecule == null || denominator == null || denominator == 0) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(molecule).divide(BigDecimal.valueOf(denominator), 2, RoundingMode.HALF_UP);
    }

}
