package com.antai.sport.http.server.repository.series.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-09-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SeriesMatch implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 系列赛id
     */
    private Long seriesId;

    /**
     * 轮次id
     */
    private Long roundId;

    /**
     * 赛区id
     */
    private Long areaId;

    /**
     * 类型 10 预选赛 20 淘汰赛
     */
    private Integer type;

    /**
     * 比赛名称
     */
    private String name;

    /**
     * 地图key
     */
    private String map;

    /**
     * 赛道key
     */
    private String path;

    /**
     * 允许进入时间
     */
    private LocalDateTime entryTime;

    /**
     * 比赛开始时间
     */
    private LocalDateTime startTime;

    /**
     * 比赛结束时间
     */
    private LocalDateTime endTime;

    /**
     * 总长度
     */
    private BigDecimal distance;

    /**
     * 爬坡高度
     */
    private BigDecimal climbDistance;

    /**
     * 描述
     */
    private String description;

    /**
     * 状态 10:未发布 20:已发布
     */
    private Integer status;

    /**
     * 显示顺序
     */
    private Integer showOrder;

    /**
     * 版本号
     */
    private Long version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改人
     */
    private Long updateBy;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


}
