package com.antai.sport.http.server.repository.app.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-08-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class AppVersion implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 1:android 2:ios
     */
    private Integer clientType;

    /**
     * 版本号x.y.z
     */
    private String version;

    /**
     * 更新内容
     */
    private String content;

    /**
     * 下载地址
     */
    private String url;

    /**
     * 下载页面地址
     */
    private String downloadPageUrl;

    /**
     * 是否强制更新
     */
    private Boolean force;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改人
     */
    private Long updateBy;

    /**
     * 修改时间
     */
    private LocalDateTime updateTime;


}
