package com.antai.sport.http.server.repository.achievement.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 
 * </p>
 *
 * @author liming
 * @since 2022-08-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class Achievement implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 分类 10 运动数值型 20 参与型
     */
    private Integer type;

    /**
     * 级别 10 初级 20 中级 30 高级
     */
    private Integer level;

    /**
     * 条件 10 登录天数 20 团练完成场数 30 日常赛完成场数 40 娱乐赛场数 50 里程 60 爬升高度 70 卡路里消耗
     */
    private Integer achievementCondition;

    /**
     * 成就名称
     */
    private String achievementName;

    /**
     * 条件数值
     */
    private Integer conditionValue;

    /**
     * 成就logo
     */
    private String logo;

    /**
     * 默认图标
     */
    private String defaultLogo;

    /**
     * 赠送积分
     */
    private Integer currency;

    /**
     * 备注
     */
    private String remark;

    /**
     * 排序号
     */
    private Integer showOrder;

    /**
     * 数据版本号
     */
    private Integer version;

    /**
     * 删除标记
     */
    private Integer deleted;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private LocalDateTime ctDate;

    /**
     * 修改人
     */
    private Long updateBy;

    /**
     * 修改时间
     */
    private LocalDateTime updateDate;


}
