package com.antai.sport.http.server.mobile.api.business.sport.user;

import com.antai.sport.http.server.constants.DeleteStatus;
import com.antai.sport.http.server.repository.sport.entity.SportUserSummary;
import com.antai.sport.http.server.repository.sport.mapper.SportUserSummaryMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;

@Service
public class SportUserSummaryService {
    @Resource
    private SportUserSummaryMapper sportUserSummaryMapper;

    public void summary(Long userId, Integer type, BigDecimal distance, BigDecimal climbDistance, Integer duration) {
        QueryWrapper<SportUserSummary> summaryQuery = new QueryWrapper<>();
        summaryQuery.eq("deleted", DeleteStatus.UNDELETED);
        summaryQuery.eq("user_id", userId);
        summaryQuery.eq("type", type);
        SportUserSummary summary = sportUserSummaryMapper.selectOne(summaryQuery);
        if (summary == null) {
            summary = new SportUserSummary();
            summary.setUserId(userId);
            summary.setType(type);
            summary.setTotalDistance(BigDecimal.ZERO);
            summary.setTotalClimbDistance(BigDecimal.ZERO);
            summary.setTotalDuration(0);
        }
        summary.setTotalDuration(summary.getTotalDuration() + duration);
        summary.setTotalDistance(summary.getTotalDistance().add(distance));
        summary.setTotalClimbDistance(summary.getTotalClimbDistance().add(climbDistance));
        if (summary.getId() == null) {
            sportUserSummaryMapper.insert(summary);
        } else {
            sportUserSummaryMapper.updateById(summary);
        }
    }
}
