package com.antai.sport.http.server.mobile.api.business.sport.social.service;

import com.antai.sport.http.server.mobile.api.business.sport.social.dto.ReqFriendRequestResponse;
import com.antai.sport.http.server.common.exception.BusinessException;
import com.antai.sport.http.server.constants.DeleteStatus;
import com.antai.sport.http.server.constants.FriendRequestStatus;
import com.antai.sport.http.server.constants.FriendStatus;
import com.antai.sport.http.server.mobile.api.business.sport.social.dto.RespFriendRequestToMe;
import com.antai.sport.http.server.mobile.api.business.sport.social.mapper.SportUserFriendRequestBusinessMapper;
import com.antai.sport.http.server.mobile.api.business.sport.social.mapper.SportUserFriendsBusinessMapper;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.sport.entity.SportUserFriendRequest;
import com.antai.sport.http.server.repository.sport.entity.SportUserFriends;
import com.antai.sport.http.server.repository.sport.mapper.SportUserFriendRequestMapper;
import com.antai.sport.http.server.repository.sport.mapper.SportUserFriendsMapper;
import com.antai.sport.http.server.repository.sport.mapper.SportUserMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

@Service
public class FriendsService {

    @Resource
    private SportUserFriendsMapper sportUserFriendsMapper;
    @Resource
    private SportUserFriendsBusinessMapper sportUserFriendsBusinessMapper;
    @Resource
    private SportUserFriendRequestBusinessMapper sportUserFriendRequestBusinessMapper;
    @Resource
    private SportUserFriendRequestMapper sportUserFriendRequestMapper;
    @Resource
    private SportUserMapper sportUserMapper;

    public List<Long> getFriends(SportUser loginUser) {
        return sportUserFriendsBusinessMapper.getFriends(loginUser.getId());
    }

    public List<RespFriendRequestToMe> getFriendsRequestToMe(SportUser loginUser) {
        return sportUserFriendRequestBusinessMapper.getFriendsRequestToMe(loginUser.getId());
    }

    @Transactional
    public Long sendFriendRequest(Long targetUserId, SportUser loginUser) {
        if (sportUserMapper.selectById(targetUserId) == null) {
            throw new BusinessException("您请求的用户不存在");
        }
        if (sportUserFriendsBusinessMapper.existFriend(loginUser.getId(), targetUserId)) {
            throw new BusinessException("你们已经是好友关系");
        }
        if (sportUserFriendRequestBusinessMapper.existFriendRequest(loginUser.getId(), targetUserId)) {
            throw new BusinessException("您已经发起好友申请，不需要重复申请!");
        }
        SportUserFriendRequest request = new SportUserFriendRequest();
        request.setSportUserId(loginUser.getId());
        request.setTargetUserId(targetUserId);
        request.setStatus(FriendRequestStatus.WAIT);
        sportUserFriendRequestMapper.insert(request);
        return request.getId();
    }

    @Transactional
    public void requestResponse(ReqFriendRequestResponse param, SportUser loginUser) {
        if (param.getResult() == null) {
            throw new BusinessException("响应结果参数异常");
        }

        SportUserFriendRequest request = sportUserFriendRequestMapper.selectById(param.getRequestId());
        if (request == null) {
            throw new BusinessException("好友请求不存在");
        }
        if (param.getResult() == null) {
            throw new BusinessException("响应结果参数异常");
        }
        if (!request.getTargetUserId().equals(loginUser.getId())) {
            throw new BusinessException("请求好友不是当前用户，响应请求失败");
        }

        request.setStatus(param.getResult() ? FriendRequestStatus.ACCEPT : FriendRequestStatus.REJECT);
        request.setLmDate(LocalDateTime.now());
        sportUserFriendRequestMapper.updateById(request);
        if (param.getResult()) {
            //建立我和他的好友关系
            QueryWrapper<SportUserFriends> myFriendQuery = new QueryWrapper<>();
            myFriendQuery.eq("deleted", DeleteStatus.UNDELETED).eq("sport_user_id", request.getTargetUserId())
                    .eq("friend_id", request.getSportUserId());
            SportUserFriends myFriend = sportUserFriendsMapper.selectOne(myFriendQuery);
            if (myFriend == null) {
                myFriend = new SportUserFriends();
                myFriend.setSportUserId(request.getTargetUserId());
                myFriend.setFriendId(request.getSportUserId());
                myFriend.setStatus(FriendStatus.TOGETHER);
                sportUserFriendsMapper.insert(myFriend);
            } else {
                if (myFriend.getStatus().equals(FriendStatus.ALONE)) {
                    myFriend.setStatus(FriendStatus.TOGETHER);
                    sportUserFriendsMapper.updateById(myFriend);
                }
            }
            //建立他和我的好友关系
            QueryWrapper<SportUserFriends> theirFriendQuery = new QueryWrapper<>();
            theirFriendQuery.eq("deleted", DeleteStatus.UNDELETED).eq("sport_user_id", request.getSportUserId())
                    .eq("friend_id", request.getTargetUserId());
            SportUserFriends theirFriend = sportUserFriendsMapper.selectOne(theirFriendQuery);
            if (theirFriend == null) {
                theirFriend = new SportUserFriends();
                theirFriend.setSportUserId(request.getSportUserId());
                theirFriend.setFriendId(request.getTargetUserId());
                theirFriend.setStatus(FriendStatus.TOGETHER);
                sportUserFriendsMapper.insert(theirFriend);
            } else {
                if (theirFriend.getStatus().equals(FriendStatus.ALONE)) {
                    theirFriend.setStatus(FriendStatus.TOGETHER);
                    sportUserFriendsMapper.updateById(theirFriend);
                }
            }
        }
    }

}
