package com.antai.sport.http.server.management.api.business.simplematch.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.management.api.business.simplematch.dto.SimpleMatchListRequestDTO;
import com.antai.sport.http.server.management.api.business.simplematch.dto.SimpleMatchListResponseDTO;
import com.antai.sport.http.server.management.api.business.simplematch.dto.SimpleMatchResponseDTO;
import com.antai.sport.http.server.management.api.business.simplematch.dto.vo.SimpleMatchVO;
import com.antai.sport.http.server.management.api.business.simplematch.service.SimpleMatchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("/simple/match")
@Api(tags = {"日常赛"})
public class SimpleMatchController {

    @Resource
    private SimpleMatchService simpleMatchService;

    @ApiOperation("加载比赛列表")
    @PostMapping("list")
    public ResponseEntity<Result<SimpleMatchListResponseDTO>> getMatchList(@RequestBody SimpleMatchListRequestDTO param) {
        return success(simpleMatchService.getMatchList(param));
    }

    @ApiOperation("删除")
    @DeleteMapping("/{matchId}")
    public ResponseEntity<Result> deleteMatch(@PathVariable("matchId") Long matchId) {
        simpleMatchService.deleteMatch(matchId);
        return success();
    }

    @ApiOperation("更改发布状态")
    @PutMapping("/{matchId}")
    public ResponseEntity<Result> publish(@PathVariable("matchId") Long matchId) {
        simpleMatchService.publish(matchId);
        return success();
    }

    @ApiOperation("获取比赛数据")
    @GetMapping("/{matchId}")
    public ResponseEntity<Result<SimpleMatchResponseDTO>> getSimpleMatch(@PathVariable("matchId") Long matchId) {
        return success(simpleMatchService.getSimpleMatch(matchId));
    }

    @ApiOperation("创建日常赛")
    @PostMapping
    public ResponseEntity<Result> save(@RequestBody SimpleMatchVO simpleMatchVO) {
        simpleMatchService.save(simpleMatchVO);
        return success();
    }





}
