package com.antai.sport.http.server.management.api.business.series.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("系列赛预选赛大区排名")
public class SeriesQualifyingMatchRankVO {
    private Long id;
    @ApiModelProperty("用户Id")
    private Long playerId;
    private String realName;
    private String idCard;
    private String phone;
    private String sex;
    @ApiModelProperty("昵称")
    private String nickname;
    @ApiModelProperty("头像")
    private String avatar;
    @ApiModelProperty("用时(秒)")
    private Integer duration;
    @ApiModelProperty("骑行总长度")
    private BigDecimal distance;
    @ApiModelProperty("爬坡高度")
    private BigDecimal climbDistance;
    @ApiModelProperty("平均功率")
    private BigDecimal avgFtp;
    @ApiModelProperty("平均速度")
    private BigDecimal avgSpeed;
    @ApiModelProperty("完成时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public LocalDateTime finishTime;

    @ApiModelProperty("体重")
    private BigDecimal weight;
    @ApiModelProperty("玩家当时ftp")
    private Integer ftp;
    @ApiModelProperty("玩家当时身高")
    private BigDecimal height;
    @ApiModelProperty("玩家当时设置最大心率")
    private Integer heartRate;
    @ApiModelProperty("玩家平均心率")
    private Integer avgHeartRate;
    @ApiModelProperty("1分钟平均最佳FTP")
    private BigDecimal oneMinutesFtp;
    @ApiModelProperty("5分钟平均最佳FTP")
    private BigDecimal fiveMinutesFtp;
    @ApiModelProperty("20分钟平均最佳FTP")
    private BigDecimal twentyMinutesFtp;
    @ApiModelProperty("1分钟平均最佳功体比")
    private BigDecimal oneMinutesWkg;
    @ApiModelProperty("5分钟平均最佳功体比")
    private BigDecimal fiveMinutesWkg;
    @ApiModelProperty("20分钟平均最佳功体比")
    private BigDecimal twentyMinutesWkg;
    @ApiModelProperty("成绩确认状态 10 待确认 20 无效 30已确认未晋级 40晋级")
    private Integer resultConfirmStatus;
    private Integer status;
}
