package com.antai.sport.http.server.management.api.business.series.mapper;

import com.antai.sport.http.server.management.api.business.series.dto.SeriesListQueryDTO;
import com.antai.sport.http.server.management.api.business.series.vo.*;
import com.antai.sport.http.server.repository.series.entity.SeriesRound;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface SeriesBusinessMapper {

    IPage<SeriesListVO> getSeriesList(IPage<SeriesListVO> pageParam, @Param("param") SeriesListQueryDTO param);

    List<SeriesRound> getRoundBySeriesId(@Param("seriesId") Long seriesId);

    List<SeriesRoundListVO> getRoundListBySeriesId(@Param("seriesId") Long seriesId);

    List<SeriesMatchListVO> getMatchByRoundId(@Param("roundId") Long roundId);

    IPage<SeriesQualifyingMatchRankVO> getSeriesQualifyingMatchRank(IPage<SeriesQualifyingMatchRankVO> page,
                                                                    @Param("roundId") Long roundId,
                                                                    @Param("areaId") Long areaId);

    IPage<SeriesQualifyingMatchRankVO> getKnockoutMatchRecord(IPage<SeriesQualifyingMatchRankVO> page,
                                                              @Param("matchId") Long matchId);

    IPage<SeriesMatchFinalistsVO> getSeriesMatchFinalists(IPage<SeriesMatchFinalistsVO> page,
                                                          @Param("seriesId") Long seriesId,
                                                          @Param("matchId") Long matchId,
                                                          @Param("preRoundId") Long preRoundId);

    IPage<SeriesMatchFinalistsVO> getCandidateWithoutQualifying(IPage<SeriesMatchFinalistsVO> page,
                                                                @Param("seriesId") Long seriesId,
                                                                @Param("roundId") Long roundId);

    IPage<SeriesMatchFinalistsVO> getCandidate(IPage<SeriesMatchFinalistsVO> page,
                                               @Param("seriesId") Long seriesId,
                                               @Param("preRoundId") Long preRoundId,
                                               @Param("roundId") Long roundId);


}
