package com.antai.sport.http.server.management.api.business.series.converter;

import com.antai.sport.http.server.management.api.business.series.dto.SeriesAreaDTO;
import com.antai.sport.http.server.management.api.business.series.dto.SeriesMatchSaveDTO;
import com.antai.sport.http.server.management.api.business.series.dto.SeriesRoundSaveDTO;
import com.antai.sport.http.server.management.api.business.series.dto.SeriesSaveDTO;
import com.antai.sport.http.server.repository.series.entity.Series;
import com.antai.sport.http.server.repository.series.entity.SeriesArea;
import com.antai.sport.http.server.repository.series.entity.SeriesMatch;
import com.antai.sport.http.server.repository.series.entity.SeriesRound;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;

@Mapper(componentModel = "spring")
public interface SeriesConverter {
    @Mapping(source = "source.logo", target = "imgUrl")
    Series toSeries(SeriesSaveDTO source);

    List<SeriesAreaDTO> toSeriesAreaDTO(List<SeriesArea> source);

    List<SeriesArea> toSeriesArea(List<SeriesAreaDTO> source);

    @Mapping(source = "source.roundId", target = "id")
    SeriesRound toSeriesRound(SeriesRoundSaveDTO source);

    SeriesMatch toSeriesMatch(SeriesMatchSaveDTO source);
}
