package com.antai.sport.http.server.management.api.business.course.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.management.api.business.course.dto.CourseItemSaveDTO;
import com.antai.sport.http.server.management.api.business.course.dto.CoursePageDTO;
import com.antai.sport.http.server.management.api.business.course.service.CourseService;
import com.antai.sport.http.server.management.api.business.course.vo.CourseDetailVO;
import com.antai.sport.http.server.management.api.business.course.vo.CourseItemVO;
import com.antai.sport.http.server.management.api.business.course.vo.CoursePageVO;
import com.antai.sport.http.server.repository.course.entity.Course;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("course")
public class CourseController {

    @Resource
    private CourseService courseService;

    @PostMapping("/page")
    public ResponseEntity<Result<CoursePageVO>> getCoursePage(@RequestBody CoursePageDTO dto) {
        return success(courseService.getCoursePage(dto));
    }

    @PutMapping("/{id}")
    public ResponseEntity<Result> changeCourseStatus(@PathVariable Long id) {
        courseService.changeCourseStatus(id);
        return success();
    }

    @DeleteMapping("/{id}")
    public ResponseEntity<Result> deleteCourse(@PathVariable Long id) {
        courseService.deleteCourse(id);
        return success();
    }

    @GetMapping("/{id}")
    public ResponseEntity<Result<CourseDetailVO>> getCourseDetail(@PathVariable Long id) {
        return success(courseService.getCourseDetail(id));
    }

    @PostMapping
    public ResponseEntity<Result> saveCourse(@RequestBody Course course) {
        courseService.saveCourse(course);
        return success();
    }

    @GetMapping("item/{courseId}")
    public ResponseEntity<Result<List<CourseItemVO>>> getCourseItem(@PathVariable Long courseId) {
        return success(courseService.getCourseItem(courseId));
    }

    @PostMapping("item")
    public ResponseEntity<Result> saveCourseItem(@RequestBody CourseItemSaveDTO dto) {
        courseService.saveCourseItem(dto);
        return success();
    }

}
