package com.antai.sport.http.server.server.api.business.user.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.traininglog.dto.SportUserTrainingLogVO;
import com.antai.sport.http.server.server.api.business.traininglog.service.SportUserTrainingLogService;
import com.antai.sport.http.server.server.api.business.user.dto.ReqSportUserTrainingLog;
import com.antai.sport.http.server.server.api.business.user.dto.RespUserHomeInfo;
import com.antai.sport.http.server.server.api.business.user.service.SportUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@Api(tags = {"用户相关接口"})
@RestController
@RequestMapping("user")
public class SportUserController {
    @Resource
    private SportUserService sportUserService;
    @Resource
    private SportUserTrainingLogService sportUserTrainingLogService;

    @ApiOperation("查询用户主页数据")
    @GetMapping("{userId}")
    public ResponseEntity<Result<RespUserHomeInfo>> getUserHomeInfo(@PathVariable("userId") Long userId) {
        return success(sportUserService.getUserHomeInfo(userId));
    }

    @ApiOperation("查询用户运动记录")
    @PostMapping("/training/log")
    public ResponseEntity<Result<List<SportUserTrainingLogVO>>> getSportUserTrainingLog(@RequestBody ReqSportUserTrainingLog param) {
        return success(sportUserTrainingLogService.getSportUserTrainingLog(param));
    }
}
