package com.antai.sport.http.server.server.api.business.traininglog.service;

import com.antai.sport.http.server.constants.DeleteStatus;
import com.antai.sport.http.server.constants.SportType;
import com.antai.sport.http.server.repository.sport.entity.SportUserSummary;
import com.antai.sport.http.server.repository.sport.entity.SportUserTrainingLog;
import com.antai.sport.http.server.repository.sport.mapper.SportUserSummaryMapper;
import com.antai.sport.http.server.repository.sport.mapper.SportUserTrainingLogMapper;
import com.antai.sport.http.server.server.api.business.traininglog.converter.SportUserTrainingLogConverter;
import com.antai.sport.http.server.server.api.business.traininglog.dto.SportUserTrainingLogSummaryVO;
import com.antai.sport.http.server.server.api.business.traininglog.dto.SportUserTrainingLogVO;
import com.antai.sport.http.server.server.api.business.traininglog.mapper.SportUserTrainingLogBusinessMapper;
import com.antai.sport.http.server.server.api.business.user.dto.ReqSportUserTrainingLog;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Service
public class SportUserTrainingLogService {
    @Resource
    private SportUserTrainingLogMapper sportUserTrainingLogMapper;
    @Resource
    private SportUserSummaryMapper sportUserSummaryMapper;

    @Resource
    private SportUserTrainingLogBusinessMapper sportUserTrainingLogBusinessMapper;

    @Resource
    private SportUserTrainingLogConverter sportUserTrainingLogConverter;

    public void createBicycleTrainingLog(Long playerId, Integer gameMode, Long sourceId,
                                         String map, String path,
                                         Integer praiseNum, CyclingDataDTO sportData) {
        SportUserTrainingLog log = sportUserTrainingLogConverter.toSportUserTrainingLog(sportData);
        log.setSportType(SportType.BICYCLE);
        log.setGameMode(gameMode);
        log.setPlayerId(playerId);
        log.setSourceId(sourceId);
        log.setMap(map);
        log.setPath(path);
        log.setPraiseNum(praiseNum);
        log.setCreateTime(LocalDateTime.now());
        log.setCreateDate(LocalDate.now());
        sportUserTrainingLogMapper.insert(log);

        QueryWrapper<SportUserSummary> summaryQuery = new QueryWrapper<>();
        summaryQuery.eq("deleted", DeleteStatus.UNDELETED);
        summaryQuery.eq("user_id", playerId);
        summaryQuery.eq("type", SportType.BICYCLE);
        SportUserSummary summary = sportUserSummaryMapper.selectOne(summaryQuery);
        if (summary == null) {
            summary = new SportUserSummary();
            summary.setUserId(playerId);
            summary.setType(SportType.BICYCLE);
            summary.setTotalDistance(BigDecimal.ZERO);
            summary.setTotalClimbDistance(BigDecimal.ZERO);
            summary.setTotalDuration(0);
            summary.setTotalPraiseNum(0);
        }
        summary.setTotalDuration(summary.getTotalDuration() + log.getDuration());
        summary.setTotalDistance(summary.getTotalDistance().add(log.getDistance()));
        summary.setTotalClimbDistance(summary.getTotalClimbDistance().add(log.getClimbDistance()));
        if (summary.getId() == null) {
            sportUserSummaryMapper.insert(summary);
        } else {
            sportUserSummaryMapper.updateById(summary);
        }

    }

    /**
     * 获取用户某个运动下的最长记录
     *
     * @param sportType
     * @param userId
     * @return
     */
    public SportUserTrainingLog getLongestTrainingLog(Integer sportType, Long userId) {
        return sportUserTrainingLogBusinessMapper.getLongestTrainingLog(sportType, userId);
    }

    /**
     * 获取时间范围内运动数据汇总
     *
     * @param sportType     运动类型
     * @param userId        用户Id
     * @param daysCondition 统计天数
     * @return
     */
    public SportUserTrainingLogSummaryVO getTrainingLogSummary(Integer sportType, Long userId, Integer daysCondition) {
        LocalDate now = LocalDate.now();
        LocalDate beginDate = now.minusDays(daysCondition - 1);
        SportUserTrainingLogSummaryVO summaryVO = sportUserTrainingLogBusinessMapper.getTrainingLogSummary(sportType, userId, beginDate, now);
        if (summaryVO == null) {
            summaryVO = new SportUserTrainingLogSummaryVO();
            summaryVO.setLongestDistance(BigDecimal.ZERO);
            summaryVO.setTotalDistance(BigDecimal.ZERO);
            summaryVO.setTotalClimbDistance(BigDecimal.ZERO);
            summaryVO.setTotalDuration(0);
        }
        return summaryVO;
    }

    /**
     * 查询用户训练记录
     *
     * @param param
     * @return
     */
    public List<SportUserTrainingLogVO> getSportUserTrainingLog(ReqSportUserTrainingLog param) {
        return sportUserTrainingLogBusinessMapper.getSportUserTrainingLog(param.getPlayerId(), param.getDate(), param.getGameMode());
    }
}
