package com.antai.sport.http.server.server.api.business.traininglog.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
@ApiModel("用户训练记录")
public class SportUserTrainingLogVO {
    @ApiModelProperty("运动类型 1:自行车 2:跑步")
    private Integer sportType;
    @ApiModelProperty("运动模式  10:漫游 20:日常赛 30:系列赛 40:课程训练 50: 团练 60:房间模式")
    private Integer gameMode;
    @ApiModelProperty("玩家id")
    private Long playerId;
    @ApiModelProperty("主数据id 如比赛为比赛id 房间模式为房间id 漫游为漫游记录id")
    private Long sourceId;
    @ApiModelProperty("运动记录Id")
    private Long recordId;
    @ApiModelProperty("地图名称")
    private String mapName;
    @ApiModelProperty("赛道名称")
    private String pathName;
    @ApiModelProperty("卡路里 临时没有数据可以先不显示")
    private Integer calorie;
    @ApiModelProperty("点赞数量")
    private Integer praiseNum;
    @ApiModelProperty("比赛名次")
    private Integer matchRank;
    @ApiModelProperty("用时(秒)")
    private Integer duration;
    @ApiModelProperty("骑行总长度")
    private BigDecimal distance;
    @ApiModelProperty("爬坡高度")
    private BigDecimal climbDistance;
    @ApiModelProperty("平均功率")
    private BigDecimal avgFtp;
    @ApiModelProperty("平均速度")
    private BigDecimal avgSpeed;
    @ApiModelProperty("记录实际那 yyyy-MM-dd HH:mm")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private LocalDateTime createTime;
}
