package com.antai.sport.http.server.server.api.business.simplematch.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.simplematch.dto.*;
import com.antai.sport.http.server.server.api.business.simplematch.service.SimpleMatchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RequestMapping("/simple/match")
@RestController
@Api(tags = {"日常赛"})
public class SimpleMatchController {

    @Resource
    private SimpleMatchService simpleMatchService;

    @ApiOperation("日常赛初始化")
    @PostMapping("init")
    public ResponseEntity<Result> init(@RequestBody ReqSimpleMatchInit initData) {
        simpleMatchService.init(initData);
        return success();
    }

    @ApiOperation("获取banner地址")
    @GetMapping("/banner/list")
    public ResponseEntity<Result<List<RespSimpleMatchBanner>>> getSimpleMatchBannerList() {
        return success(simpleMatchService.getSimpleMatchBannerList());
    }

    @ApiOperation("通过用户id查询未完赛事列表")
    @GetMapping("/list/user/{userId}")
    public ResponseEntity<Result<List<RespSimpleMatchList>>> getUnFinishedSimpleMatchForUser(@PathVariable("userId") Long userId) {
        return success(simpleMatchService.getUnFinishedSimpleMatchForUser(userId));
    }

    @ApiOperation("查询所有未完赛事列表")
    @GetMapping("/list")
    public ResponseEntity<Result<List<RespSimpleMatchList>>> getUnFinishedSimpleMatchForServer() {
        return success(simpleMatchService.getUnFinishedSimpleMatchForServer());
    }

    @ApiOperation("赛事报名")
    @PostMapping("/regist")
    public ResponseEntity<Result> regist(@RequestBody ReqSimpleMatchRegist param) {
        simpleMatchService.regist(param);
        return success();
    }

    @ApiOperation("赛事明细")
    @PostMapping("/info")
    public ResponseEntity<Result<RespSimpleMatchInfo>> matchInfo(@RequestBody ReqMatchInfo param) {
        return success(simpleMatchService.matchInfo(param));
    }

    @ApiOperation("加入赛事初始化")
    @PostMapping("/record/init")
    public ResponseEntity<Result<RespSimpleMatchRecordInit>> recordInit(@RequestBody ReqSimpleMatchRecordInit param) {
        return success(simpleMatchService.recordInit(param));
    }


    @ApiOperation("比赛记录上传")
    @PostMapping("/record/upload")
    public ResponseEntity<Result> recordUpload(@RequestBody List<ReqSimpleMatchRecord> dataList) {
        simpleMatchService.recordUpload(dataList);
        return success();
    }

    @ApiOperation("查询日常赛排名")
    @GetMapping("/rank/{matchId}")
    public ResponseEntity<Result<List<RespSimpleMatchRank>>> rank(@PathVariable("matchId") Long matchId) {
        return success(simpleMatchService.rank(matchId));
    }

}
