package com.antai.sport.http.server.server.api.common.dto;

import com.antai.sport.http.server.server.api.utils.ScoreUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;

@Data
@ApiModel("基础骑行数据上传对象")
public class CyclingDataDTO {
    @ApiModelProperty("比赛名次(没有可以不填)")
    private Integer matchRank;
    @ApiModelProperty("记录id")
    private Long recordId;
    @ApiModelProperty("用时(秒)")
    private Integer duration;
    @ApiModelProperty("骑行总长度")
    private BigDecimal distance;
    @ApiModelProperty("爬坡高度")
    private BigDecimal climbDistance;
    @ApiModelProperty("平均功率")
    private BigDecimal avgFtp;
    @ApiModelProperty("平均速度")
    private BigDecimal avgSpeed;
    @ApiModelProperty("卡路里")
    private Integer calorie;
    @ApiModelProperty("1分钟平均最佳功率")
    private BigDecimal oneMinutesFtp;
    @ApiModelProperty("5分钟平均最佳功率")
    private BigDecimal fiveMinutesFtp;
    @ApiModelProperty("20分钟平均最佳功率")
    private BigDecimal twentyMinutesFtp;
    @ApiModelProperty("fit文件地址")
    private String fitUrl;
    @ApiModelProperty("状态 10:未完赛 20:已完赛")
    public Integer status;
    @ApiModelProperty("完成时间 yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public LocalDateTime finishTime;

    @ApiModelProperty(hidden = true)
    @JsonIgnore
    private BigDecimal weight;
    @ApiModelProperty(hidden = true)
    @JsonIgnore
    private BigDecimal oneMinutesWkg;
    @ApiModelProperty(hidden = true)
    @JsonIgnore
    private BigDecimal fiveMinutesWkg;
    @ApiModelProperty(hidden = true)
    @JsonIgnore
    private BigDecimal twentyMinutesWkg;
    @ApiModelProperty(hidden = true)
    @JsonIgnore
    private BigDecimal score;

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
        this.weight = this.weight == null ? BigDecimal.ZERO : this.weight;
        this.oneMinutesFtp = this.oneMinutesFtp == null ? BigDecimal.ZERO : this.oneMinutesFtp;
        this.fiveMinutesFtp = this.fiveMinutesFtp == null ? BigDecimal.ZERO : this.fiveMinutesFtp;
        this.twentyMinutesFtp = this.twentyMinutesFtp == null ? BigDecimal.ZERO : this.twentyMinutesFtp;
        this.calorie = this.calorie == null ? 0 : this.calorie;

        this.oneMinutesWkg = handleWkg(this.oneMinutesFtp, this.weight);
        this.fiveMinutesWkg = handleWkg(this.fiveMinutesFtp, this.weight);
        this.twentyMinutesWkg = handleWkg(this.twentyMinutesFtp, this.weight);

        this.score = ScoreUtils.calculate(this.oneMinutesFtp, this.fiveMinutesFtp, this.twentyMinutesFtp, this.oneMinutesWkg, this.fiveMinutesWkg, this.twentyMinutesWkg);

    }

    private BigDecimal handleWkg(BigDecimal ftp, BigDecimal weight) {
        if (ftp.compareTo(BigDecimal.ZERO) == 0 || weight.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        } else {
            return ftp.divide(weight, 1, RoundingMode.HALF_UP);
        }
    }

}
