package com.antai.sport.http.server.server.api.business.user.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class SportUserMonthRankResponseDTO {
    @ApiModelProperty("玩家id")
    private Long playerId;
    @ApiModelProperty("排名")
    private Integer rank;
    @ApiModelProperty("昵称")
    private String nickname;
    @ApiModelProperty("头像")
    private String avatar;
    @ApiModelProperty("体重")
    private BigDecimal weight;
    @ApiModelProperty("总计卡路里")
    private Integer totalCalorie;
    @ApiModelProperty("能力评分")
    private BigDecimal score;
    @ApiModelProperty("一分钟FTP")
    private BigDecimal oneMinutesFtp;
    @ApiModelProperty("五分钟FTP")
    private BigDecimal fiveMinutesFtp;
    @ApiModelProperty("二十分钟FTP")
    private BigDecimal twentyMinutesFtp;
    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime updateTime;
}
