package com.antai.sport.http.server.server.api.business.tour.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.server.api.business.tour.dto.ReqTourRecordInit;
import com.antai.sport.http.server.server.api.business.tour.dto.RespTourRecordInit;
import com.antai.sport.http.server.server.api.business.tour.service.TourService;
import com.antai.sport.http.server.server.api.common.dto.CyclingDataDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RequestMapping("tour")
@RestController
@Api(tags = {"漫游模式"})
public class TourController {

    @Resource
    private TourService tourService;

    @ApiOperation("初始化漫游记录")
    @PostMapping("/init")
    public ResponseEntity<Result<RespTourRecordInit>> init(@RequestBody ReqTourRecordInit initData) {
        return success(tourService.init(initData));
    }

    @ApiOperation("漫游记录上传")
    @PostMapping("/record/upload")
    public ResponseEntity<Result> upload(@RequestBody List<CyclingDataDTO> tourRecordList){
        tourService.upload(tourRecordList);
        return success();
    }
}
