package com.antai.sport.http.server.server.api.business.base.controller;

import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.repository.base.entity.GameMode;
import com.antai.sport.http.server.server.api.business.base.dto.AreaRespDTO;
import com.antai.sport.http.server.server.api.business.base.service.BaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@RequestMapping("base")
@Api(tags = {"基础接口"})
public class BaseController {
    @Resource
    private BaseService baseService;

    @ApiOperation(value = "查询游戏模式列表", notes = "返回结果中code 为模式码 name 为模式名称")
    @GetMapping("/game/mode")
    public ResponseEntity<Result<List<GameMode>>> getGameMode() {
        return success(baseService.getGameMode());
    }


    @ApiOperation(value = "查询省", notes = "返回结果中code 为模式码 name 为模式名称")
    @GetMapping("/area")
    public ResponseEntity<Result<List<AreaRespDTO>>> getProvince(@RequestParam(required = false) Long parentId) {
        return success(baseService.getArea(parentId));
    }
}
