package com.antai.sport.http.server.mobile.api.business.train.record.service;

import com.antai.sport.http.server.constants.SportType;
import com.antai.sport.http.server.mobile.api.business.sport.user.SportUserSummaryService;
import com.antai.sport.http.server.mobile.api.business.train.record.dto.ReqTrainRecord;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import com.antai.sport.http.server.repository.train.entity.TrainBicycleRecord;
import com.antai.sport.http.server.repository.train.entity.TrainRunRecord;
import com.antai.sport.http.server.repository.train.mapper.TrainBicycleRecordMapper;
import com.antai.sport.http.server.repository.train.mapper.TrainRunRecordMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

@Service
public class TrainRecordService {
    @Resource
    private SportUserSummaryService sportUserSummaryService;
    @Resource
    private TrainBicycleRecordMapper trainBicycleRecordMapper;
    @Resource
    private TrainRunRecordMapper trainRunRecordMapper;

    @Transactional
    public void saveRecord(SportUser loginUser, ReqTrainRecord data) {
        if (data.getSportType().equals(SportType.BICYCLE)) {
            TrainBicycleRecord record = new TrainBicycleRecord();
            record.setUserId(loginUser.getId());
            record.setStartTime(data.getStartTime());
            record.setEndTime(data.getEndTime());
            record.setDuration(data.getDuration());
            record.setClimbDistance(data.getClimbDistance());
            record.setDistance(data.getDistance());
            record.setAvgFtp(data.getAvgFtp());
            record.setAvgSpeed(data.getAvgSpeed());
            trainBicycleRecordMapper.insert(record);
        } else {
            TrainRunRecord record = new TrainRunRecord();
            record.setUserId(loginUser.getId());
            record.setStartTime(data.getStartTime());
            record.setEndTime(data.getEndTime());
            record.setDuration(data.getDuration());
            record.setClimbDistance(data.getClimbDistance());
            record.setDistance(data.getDistance());
            record.setAvgSpeed(data.getAvgSpeed());
            record.setPace(data.getPace());
            trainRunRecordMapper.insert(record);
        }

        //汇总数据
        sportUserSummaryService.summary(loginUser.getId(), data.getSportType(), data.getDistance(),
                data.getClimbDistance(), data.getDuration());

    }
}
