package com.antai.sport.http.server.mobile.api.business.sport.user.dto;

import com.antai.sport.http.server.repository.sport.entity.SportSection;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author liming
 * @Date 2021/8/23 15:48
 * @Email lmmax@126.com
 * @Description:
 */
@Data
public class RespSportSection {

    public RespSportSection(SportSection sportSection) {
        this.id = sportSection.getId();
        this.type = sportSection.getType();
        this.name = sportSection.getName();
        this.key = sportSection.getSectionKey();
    }

    @ApiModelProperty("部位id")
    private Long id;
    @ApiModelProperty("部位类型")
    private Integer type;
    @ApiModelProperty("部位名称")
    private String name;
    @ApiModelProperty("部位key")
    private String key;
    @ApiModelProperty("当前选中皮肤key")
    private String skinKey;

    @ApiModelProperty("皮肤列表")
    List<RespSportSectionSkin> skinList;
}
