package com.antai.sport.http.server.mobile.api.business.sport.social.controller;

import com.antai.sport.http.server.mobile.api.business.sport.social.dto.ReqChatHistoryQueryParam;
import com.antai.sport.http.server.mobile.api.business.sport.social.dto.ReqChatMessage;
import com.antai.sport.http.server.mobile.api.business.sport.social.dto.RespChatHistory;
import com.antai.sport.http.server.common.annotation.LoginSportUser;
import com.antai.sport.http.server.common.base.Result;
import com.antai.sport.http.server.mobile.api.business.sport.social.service.ChatService;
import com.antai.sport.http.server.repository.sport.entity.SportUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

import static com.antai.sport.http.server.common.util.ResultUtil.success;

@RestController
@Api(tags = {"社交相关接口"})
@RequestMapping("/chat")
public class ChatController {

    @Resource
    private ChatService chatService;

    @ApiOperation(value = "发送聊天信息", notes = "data中为聊天记录id")
    @PostMapping("message")
    public ResponseEntity<Result<Long>> sendMessage(@RequestBody ReqChatMessage message, @LoginSportUser SportUser loginUser) {
        return success(chatService.sendMessage(message, loginUser));
    }

    @ApiOperation(value = "查询聊天记录")
    @PostMapping("history")
    public ResponseEntity<Result<List<RespChatHistory>>> getChatHistory(@RequestBody ReqChatHistoryQueryParam param) {
        return success(chatService.getChatHistory(param));
    }


}
