package com.antai.sport.http.server.common.service;

import com.antai.sport.http.server.common.util.SmsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @Author liming
 * @Date 2021/8/23 10:51
 * @Email lmmax@126.com
 * @Description:
 */
@Service
public class CommonSmsService {
    Logger logger = LoggerFactory.getLogger(CommonSmsService.class);
    @Value("${aliyun.sms.sign:null}")
    private String sign;
    @Value("${aliyun.sms.template-code.login:null}")
    private String loginTemplateCode;

    @Resource
    private SmsUtil smsUtil;

    public void sendLoginSmsCaptcha(String phone, String code) {
        try {
            String errorMsg = smsUtil.sendSms(sign, loginTemplateCode, Map.of("code", code), phone);
            if (errorMsg != null) {
                logger.error(errorMsg);
            }
        } catch (Exception ex) {
            logger.error("短信发送失败", ex);
        }
    }
}
